/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import zju.cst.aces.graph.Edge;
import zju.cst.aces.graph.Graph;
import zju.cst.aces.graph.Node;

class GraphHelper {
    GraphHelper() {
    }

    public static <N extends Node<?>, E extends Edge<N>> Set<N> findPredecessors(Graph<N, E> graph, N startNode) {
        HashSet predecessors = new HashSet();
        LinkedList queue = new LinkedList();
        queue.add(startNode);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            for (Edge edge : graph.getEdges()) {
                if (!edge.getTarget().equals(current) || predecessors.contains(edge.getSource())) continue;
                predecessors.add(edge.getSource());
                queue.add(edge.getSource());
            }
        }
        return predecessors;
    }

    public static <N extends Node<?>, E extends Edge<N>> List<N> dfs(Graph<N, E> graph, N startNode) {
        ArrayList<Node> visited = new ArrayList<Node>();
        Stack stack = new Stack();
        stack.push(startNode);
        while (!stack.isEmpty()) {
            Node current = (Node)stack.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            for (Edge edge : graph.getEdges()) {
                if (!edge.getSource().equals(current)) continue;
                stack.push(edge.getTarget());
            }
        }
        return visited;
    }

    public static <N extends Node<?>, E extends Edge<N>> List<N> bfs(Graph<N, E> graph, N startNode) {
        ArrayList<Node> visited = new ArrayList<Node>();
        LinkedList queue = new LinkedList();
        queue.add(startNode);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            for (Edge edge : graph.getEdges()) {
                if (!edge.getSource().equals(current)) continue;
                queue.add(edge.getTarget());
            }
        }
        return visited;
    }
}

