/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.dto;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.List;
import java.util.stream.Collectors;
import zju.cst.aces.dto.PromptInfo;
import zju.cst.aces.runner.AbstractRunner;

public class TestSkeleton {
    private String testName;
    private String fullTestName;
    private String packageName;
    private List<String> imports;
    private String skeleton = "@ExtendWith(MockitoExtension.class)\npublic class TestClass {\n}";
    private static String sk = "package com.selimhorri.app.service.impl;\nimport java.util.List;\nimport java.util.stream.Collectors;\nimport javax.transaction.Transactional;\nimport org.springframework.stereotype.Service;\nimport org.springframework.web.client.RestTemplate;\nimport com.selimhorri.app.constant.AppConstant;\nimport com.selimhorri.app.domain.id.OrderItemId;\nimport com.selimhorri.app.dto.OrderDto;\nimport com.selimhorri.app.dto.OrderItemDto;\nimport com.selimhorri.app.dto.ProductDto;\nimport com.selimhorri.app.exception.wrapper.OrderItemNotFoundException;\nimport com.selimhorri.app.helper.OrderItemMappingHelper;\nimport com.selimhorri.app.repository.OrderItemRepository;\nimport com.selimhorri.app.service.OrderItemService;\nimport lombok.RequiredArgsConstructor;\nimport lombok.extern.slf4j.Slf4j;\n@Service\n@Transactional\n@Slf4j\n@RequiredArgsConstructor\npublic class OrderItemServiceImpl {\n}";

    public static void main(String[] args) {
        TestSkeleton testSkeleton = new TestSkeleton(sk);
        String code = testSkeleton.build("@Test\npublic void testMethod(){}");
        System.out.println(code);
    }

    public TestSkeleton(String skeleton) {
        this.skeleton = skeleton;
        this.packageName = "";
        CompilationUnit cu = StaticJavaParser.parse((String)skeleton);
        cu.getPackageDeclaration().ifPresent(p -> {
            this.packageName = p.getNameAsString();
        });
        this.testName = ((ClassOrInterfaceDeclaration)cu.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow()).getNameAsString();
        this.fullTestName = this.packageName + "." + this.testName;
        this.imports = cu.getImports().stream().map(i -> i.toString().trim()).collect(Collectors.toList());
    }

    public TestSkeleton(PromptInfo promptInfo) {
        this.fullTestName = promptInfo.getFullTestName();
        this.testName = this.fullTestName.lastIndexOf(".") == -1 ? this.fullTestName : this.fullTestName.substring(this.fullTestName.lastIndexOf(".") + 1);
        this.packageName = promptInfo.classInfo.packageName;
        this.imports = promptInfo.classInfo.imports;
        this.skeleton = AbstractRunner.repairPackage(this.skeleton, this.packageName);
        this.skeleton = AbstractRunner.repairImports(this.skeleton, this.imports);
        this.skeleton = AbstractRunner.changeTestName(this.skeleton, this.testName);
    }

    public String build(String testMethod) {
        CompilationUnit cu = StaticJavaParser.parse((String)this.skeleton);
        MethodDeclaration tm = StaticJavaParser.parseMethodDeclaration((String)testMethod);
        cu.getClassByName(this.testName).ifPresent(c -> c.addMember((BodyDeclaration)tm));
        return cu.toString();
    }

    public String getTestName() {
        return this.testName;
    }

    public String getFullTestName() {
        return this.fullTestName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public String getSkeleton() {
        return this.skeleton;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void setFullTestName(String fullTestName) {
        this.fullTestName = fullTestName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public void setSkeleton(String skeleton) {
        this.skeleton = skeleton;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestSkeleton)) {
            return false;
        }
        TestSkeleton other = (TestSkeleton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$testName = this.getTestName();
        String other$testName = other.getTestName();
        if (this$testName == null ? other$testName != null : !this$testName.equals(other$testName)) {
            return false;
        }
        String this$fullTestName = this.getFullTestName();
        String other$fullTestName = other.getFullTestName();
        if (this$fullTestName == null ? other$fullTestName != null : !this$fullTestName.equals(other$fullTestName)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        List<String> this$imports = this.getImports();
        List<String> other$imports = other.getImports();
        if (this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports)) {
            return false;
        }
        String this$skeleton = this.getSkeleton();
        String other$skeleton = other.getSkeleton();
        return !(this$skeleton == null ? other$skeleton != null : !this$skeleton.equals(other$skeleton));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestSkeleton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $testName = this.getTestName();
        result = result * 59 + ($testName == null ? 43 : $testName.hashCode());
        String $fullTestName = this.getFullTestName();
        result = result * 59 + ($fullTestName == null ? 43 : $fullTestName.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        List<String> $imports = this.getImports();
        result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
        String $skeleton = this.getSkeleton();
        result = result * 59 + ($skeleton == null ? 43 : $skeleton.hashCode());
        return result;
    }

    public String toString() {
        return "TestSkeleton(testName=" + this.getTestName() + ", fullTestName=" + this.getFullTestName() + ", packageName=" + this.getPackageName() + ", imports=" + this.getImports() + ", skeleton=" + this.getSkeleton() + ")";
    }
}

