/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.dto;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import zju.cst.aces.dto.ChatChoice;
import zju.cst.aces.dto.ChatUsage;
import zju.cst.aces.dto.Message;

public class ChatResponse {
    private String id;
    private String model;
    private Long created;
    private String object;
    private ChatUsage usage;
    private List<ChatChoice> choices;

    public List<Message> getMessages() {
        if (this.choices == null || this.choices.isEmpty()) {
            return Collections.emptyList();
        }
        return this.choices.stream().map(ChatChoice::getMessage).collect(Collectors.toList());
    }

    public String getContent() {
        if (this.choices == null || this.choices.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ChatChoice choice : this.choices) {
            Message message = choice.getMessage();
            if (message == null || message.getContent() == null) continue;
            sb.append(message.getContent());
        }
        return sb.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getModel() {
        return this.model;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getObject() {
        return this.object;
    }

    public ChatUsage getUsage() {
        return this.usage;
    }

    public List<ChatChoice> getChoices() {
        return this.choices;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setUsage(ChatUsage usage) {
        this.usage = usage;
    }

    public void setChoices(List<ChatChoice> choices) {
        this.choices = choices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatResponse)) {
            return false;
        }
        ChatResponse other = (ChatResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        ChatUsage this$usage = this.getUsage();
        ChatUsage other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        List<ChatChoice> this$choices = this.getChoices();
        List<ChatChoice> other$choices = other.getChoices();
        return !(this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        ChatUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        List<ChatChoice> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        return result;
    }

    public String toString() {
        return "ChatResponse(id=" + this.getId() + ", model=" + this.getModel() + ", created=" + this.getCreated() + ", object=" + this.getObject() + ", usage=" + this.getUsage() + ", choices=" + this.getChoices() + ")";
    }
}

