/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.impl.obfuscator.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.jar.JarFile;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import zju.cst.aces.api.impl.obfuscator.frame.Symbol;
import zju.cst.aces.api.impl.obfuscator.frame.SymbolFrame;
import zju.cst.aces.api.impl.obfuscator.util.ASMParser;

public class SymbolAnalyzer {
    private static final String jarFile = "";

    public static void main(String[] args) throws IOException {
        HashSet<ClassNode> candidateClasses = new HashSet<ClassNode>();
        ASMParser asmParser = new ASMParser(null);
        candidateClasses.addAll(asmParser.loadClasses(new JarFile(jarFile)));
        SymbolAnalyzer analyzer = new SymbolAnalyzer();
        for (ClassNode classNode : candidateClasses) {
            analyzer.analyze(classNode);
        }
    }

    public SymbolFrame analyze(ClassNode classNode) {
        SymbolFrame frame = new SymbolFrame();
        String className = classNode.name;
        frame.setClassName(className);
        frame.setSuperName(classNode.superName);
        frame.setInterfaces(classNode.interfaces);
        for (FieldNode fieldNode : classNode.fields) {
            String type = fieldNode.signature != null ? fieldNode.signature : fieldNode.desc;
            frame.addFieldDef(new Symbol(fieldNode.name, className, type, null));
        }
        for (MethodNode methodNode : classNode.methods) {
            frame.merge(this.analyzeMethod(methodNode, className));
        }
        return frame;
    }

    public SymbolFrame analyzeMethod(MethodNode methodNode, String className) {
        ArrayList localVariables = new ArrayList();
        if (methodNode.localVariables != null) {
            localVariables.addAll(methodNode.localVariables);
        }
        SymbolFrame frame = new SymbolFrame();
        frame.addMethodDef(new Symbol(methodNode.name, className, methodNode.signature, null));
        localVariables.forEach(var -> {
            if (methodNode.parameters != null) {
                methodNode.parameters.forEach(param -> {
                    if (param.name.equals(var.name)) {
                        frame.addVarDef(new Symbol(var.name, var.desc, var.desc, null));
                    }
                });
            }
        });
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (insn instanceof FieldInsnNode) {
                FieldInsnNode fi = (FieldInsnNode)insn;
                frame.addFieldUse(new Symbol(fi.name, fi.owner, fi.desc, this.getLine(insn)));
            }
            if (insn instanceof MethodInsnNode) {
                MethodInsnNode mi = (MethodInsnNode)insn;
                frame.addMethodUse(new Symbol(mi.name, mi.owner, mi.desc, this.getLine(insn)));
            }
            if (insn instanceof VarInsnNode) {
                LocalVariableNode var2;
                VarInsnNode vi = (VarInsnNode)insn;
                if (vi.var >= localVariables.size()) continue;
                if (vi.getOpcode() == 58) {
                    var2 = (LocalVariableNode)localVariables.get(vi.var);
                    frame.addVarDef(new Symbol(var2.name, var2.desc, var2.desc, this.getLine(insn)));
                } else if (vi.getOpcode() == 25) {
                    var2 = (LocalVariableNode)localVariables.get(vi.var);
                    if (var2.name.equals("this")) continue;
                    frame.addVarUse(new Symbol(var2.name, var2.desc, var2.desc, this.getLine(insn)));
                }
            }
            if (!(insn instanceof InvokeDynamicInsnNode)) continue;
            InvokeDynamicInsnNode di = (InvokeDynamicInsnNode)insn;
            Arrays.stream(di.bsmArgs).filter(arg -> arg instanceof Handle).map(arg -> (Handle)arg).forEach(handle -> frame.addMethodUse(new Symbol(handle.getName(), handle.getOwner(), handle.getDesc(), this.getLine(insn))));
        }
        return frame;
    }

    public int getLine(AbstractInsnNode insn) {
        while (insn != null && !(insn instanceof LineNumberNode)) {
            insn = insn.getPrevious();
        }
        return insn == null ? -1 : ((LineNumberNode)insn).line;
    }
}

