/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.impl.obfuscator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import zju.cst.aces.api.config.Config;

public class ASMParser {
    private final Config config;

    public ASMParser(Config config) {
        this.config = config;
    }

    Set<String> getEntries(Set<ClassNode> classNodes, Collection<String> methodSigs) {
        HashSet<String> entries = new HashSet<String>();
        return entries;
    }

    public Set<ClassNode> loadClasses(File classFile) throws IOException {
        HashSet<ClassNode> classes = new HashSet<ClassNode>();
        FileInputStream is = new FileInputStream(classFile);
        return this.readClass(classFile.getName(), is, classes);
    }

    public Set<ClassNode> loadClasses(JarFile jarFile) throws IOException {
        HashSet<ClassNode> targetClasses = new HashSet<ClassNode>();
        Stream<JarEntry> str = jarFile.stream();
        str.forEach(z -> this.readJar(jarFile, (JarEntry)z, (Set<ClassNode>)targetClasses));
        jarFile.close();
        return targetClasses;
    }

    private Set<ClassNode> readClass(String className, InputStream is, Set<ClassNode> targetClasses) {
        try {
            BufferedSource source = Okio.buffer((Source)Okio.source((InputStream)is));
            byte[] bytes = source.readByteArray();
            String cafebabe = String.format("%02X%02X%02X%02X", bytes[0], bytes[1], bytes[2], bytes[3]);
            if (!cafebabe.toLowerCase().equals("cafebabe")) {
                return targetClasses;
            }
            ClassNode cn = this.getNode(bytes);
            targetClasses.add(cn);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to read class {}" + className + ": " + e);
        }
        return targetClasses;
    }

    private Set<ClassNode> readJar(JarFile jar, JarEntry entry, Set<ClassNode> targetClasses) {
        String name = entry.getName();
        if (name.endsWith(".class")) {
            Set<ClassNode> set;
            block11: {
                String className = name.replace(".class", "").replace("/", ".");
                InputStream jis = jar.getInputStream(entry);
                try {
                    set = this.readClass(className, jis, targetClasses);
                    if (jis == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (jis != null) {
                            try {
                                jis.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.config.getLog().warn("Fail to read class {} in jar {}" + entry + jar.getName() + e);
                    }
                }
                jis.close();
            }
            return set;
        } else if (name.endsWith("jar") || name.endsWith("war")) {
            // empty if block
        }
        return targetClasses;
    }

    private ClassNode getNode(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        try {
            cr.accept((ClassVisitor)cn, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cr = null;
        return cn;
    }
}

