/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.impl.obfuscator.frame;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import zju.cst.aces.api.impl.obfuscator.frame.Symbol;

public class SymbolFrame {
    private String className;
    private String superName;
    private List<String> interfaces;
    private Set<Symbol> fieldDef = new HashSet<Symbol>();
    private Set<Symbol> fieldUse = new HashSet<Symbol>();
    private Set<Symbol> varDef = new HashSet<Symbol>();
    private Set<Symbol> varUse = new HashSet<Symbol>();
    private Set<Symbol> methodDef = new HashSet<Symbol>();
    private Set<Symbol> methodUse = new HashSet<Symbol>();

    public void addFieldDef(Symbol symbol) {
        this.fieldDef.add(symbol);
    }

    public void addFieldUse(Symbol symbol) {
        this.fieldUse.add(symbol);
    }

    public void addVarDef(Symbol symbol) {
        this.varDef.add(symbol);
    }

    public void addVarUse(Symbol symbol) {
        this.varUse.add(symbol);
    }

    public void addMethodDef(Symbol symbol) {
        this.methodDef.add(symbol);
    }

    public void addMethodUse(Symbol symbol) {
        this.methodUse.add(symbol);
    }

    public void merge(SymbolFrame frame) {
        if (frame == null) {
            return;
        }
        if (frame.fieldDef != null) {
            this.fieldDef.addAll(frame.fieldDef);
        }
        if (frame.fieldUse != null) {
            this.fieldUse.addAll(frame.fieldUse);
        }
        if (frame.varDef != null) {
            this.varDef.addAll(frame.varDef);
        }
        if (frame.varUse != null) {
            this.varUse.addAll(frame.varUse);
        }
        if (frame.methodDef != null) {
            this.methodDef.addAll(frame.methodDef);
        }
        if (frame.methodUse != null) {
            this.methodUse.addAll(frame.methodUse);
        }
    }

    public void filterSymbolsByGroupId(List<String> groupIds) {
        if (groupIds == null || groupIds.isEmpty()) {
            return;
        }
        List targets = groupIds.stream().map(id -> id.replace(".", "/")).collect(Collectors.toList());
        this.className = SymbolFrame.isClassInGroup(this.className, groupIds) ? this.className.substring(this.className.lastIndexOf("/") + 1) : null;
        this.superName = SymbolFrame.isClassInGroup(this.superName, groupIds) ? this.superName.substring(this.superName.lastIndexOf("/") + 1) : null;
        for (int i = 0; i < this.interfaces.size(); ++i) {
            String interfaceName = this.interfaces.get(i);
            if (SymbolFrame.isClassInGroup(interfaceName, groupIds)) {
                this.interfaces.set(i, interfaceName.substring(interfaceName.lastIndexOf("/") + 1));
                continue;
            }
            this.interfaces.remove(i);
            --i;
        }
        this.fieldDef.removeIf(symbol -> !symbol.isInGroup(targets));
        this.fieldUse.removeIf(symbol -> !symbol.isInGroup(targets));
        this.varDef.removeIf(symbol -> !symbol.isInGroup(targets));
        this.varUse.removeIf(symbol -> !symbol.isInGroup(targets));
        this.methodDef.removeIf(symbol -> !symbol.isInGroup(targets));
        this.methodUse.removeIf(symbol -> !symbol.isInGroup(targets));
    }

    public Set<String> toObNames(List<String> groupIds) {
        HashSet<String> obNames = new HashSet<String>();
        if (this.className != null) {
            obNames.add(this.className);
        }
        if (this.superName != null) {
            obNames.add(this.superName);
        }
        if (this.interfaces != null) {
            obNames.addAll(this.interfaces);
        }
        obNames.addAll(this.fieldDef.stream().map(Symbol::getName).collect(Collectors.toSet()));
        obNames.addAll(this.fieldDef.stream().map(s -> this.splitTypeName(s.getOwner(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.fieldDef.stream().map(s -> this.splitTypeName(s.getType(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.fieldUse.stream().map(Symbol::getName).collect(Collectors.toSet()));
        obNames.addAll(this.fieldUse.stream().map(s -> this.splitTypeName(s.getOwner(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.fieldUse.stream().map(s -> this.splitTypeName(s.getType(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.varDef.stream().map(Symbol::getName).collect(Collectors.toSet()));
        obNames.addAll(this.varDef.stream().map(s -> this.splitTypeName(s.getOwner(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.varDef.stream().map(s -> this.splitTypeName(s.getType(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.varUse.stream().map(Symbol::getName).collect(Collectors.toSet()));
        obNames.addAll(this.varUse.stream().map(s -> this.splitTypeName(s.getOwner(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.varUse.stream().map(s -> this.splitTypeName(s.getType(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.methodDef.stream().map(Symbol::getName).collect(Collectors.toSet()));
        obNames.addAll(this.methodDef.stream().map(s -> this.splitTypeName(s.getOwner(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.methodDef.stream().map(s -> this.splitTypeName(s.getType(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.methodUse.stream().map(Symbol::getName).collect(Collectors.toSet()));
        obNames.addAll(this.methodUse.stream().map(s -> this.splitTypeName(s.getOwner(), groupIds)).collect(Collectors.toSet()));
        obNames.addAll(this.methodUse.stream().map(s -> this.splitTypeName(s.getType(), groupIds)).collect(Collectors.toSet()));
        obNames.remove("");
        return obNames;
    }

    public String splitTypeName(String type, List<String> groupIds) {
        if (type == null || type.isEmpty() || !SymbolFrame.isClassInGroup(type, groupIds)) {
            return "";
        }
        String[] parts = type.split("/");
        String ret = parts[parts.length - 1];
        if (ret.contains("$")) {
            ret = ret.substring(ret.lastIndexOf("$") + 1);
        }
        if (ret.contains(";")) {
            ret = ret.substring(0, ret.indexOf(";"));
        }
        return ret;
    }

    public static boolean isClassInGroup(String fullClassName, List<String> groupIds) {
        for (String gid : groupIds) {
            if (!fullClassName.contains(gid.replace(".", "/"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isInGroup(String str, List<String> groupIds) {
        for (String gid : groupIds) {
            if (!str.contains(gid)) continue;
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public Set<Symbol> getFieldDef() {
        return this.fieldDef;
    }

    public Set<Symbol> getFieldUse() {
        return this.fieldUse;
    }

    public Set<Symbol> getVarDef() {
        return this.varDef;
    }

    public Set<Symbol> getVarUse() {
        return this.varUse;
    }

    public Set<Symbol> getMethodDef() {
        return this.methodDef;
    }

    public Set<Symbol> getMethodUse() {
        return this.methodUse;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSuperName(String superName) {
        this.superName = superName;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public void setFieldDef(Set<Symbol> fieldDef) {
        this.fieldDef = fieldDef;
    }

    public void setFieldUse(Set<Symbol> fieldUse) {
        this.fieldUse = fieldUse;
    }

    public void setVarDef(Set<Symbol> varDef) {
        this.varDef = varDef;
    }

    public void setVarUse(Set<Symbol> varUse) {
        this.varUse = varUse;
    }

    public void setMethodDef(Set<Symbol> methodDef) {
        this.methodDef = methodDef;
    }

    public void setMethodUse(Set<Symbol> methodUse) {
        this.methodUse = methodUse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SymbolFrame)) {
            return false;
        }
        SymbolFrame other = (SymbolFrame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$superName = this.getSuperName();
        String other$superName = other.getSuperName();
        if (this$superName == null ? other$superName != null : !this$superName.equals(other$superName)) {
            return false;
        }
        List<String> this$interfaces = this.getInterfaces();
        List<String> other$interfaces = other.getInterfaces();
        if (this$interfaces == null ? other$interfaces != null : !((Object)this$interfaces).equals(other$interfaces)) {
            return false;
        }
        Set<Symbol> this$fieldDef = this.getFieldDef();
        Set<Symbol> other$fieldDef = other.getFieldDef();
        if (this$fieldDef == null ? other$fieldDef != null : !((Object)this$fieldDef).equals(other$fieldDef)) {
            return false;
        }
        Set<Symbol> this$fieldUse = this.getFieldUse();
        Set<Symbol> other$fieldUse = other.getFieldUse();
        if (this$fieldUse == null ? other$fieldUse != null : !((Object)this$fieldUse).equals(other$fieldUse)) {
            return false;
        }
        Set<Symbol> this$varDef = this.getVarDef();
        Set<Symbol> other$varDef = other.getVarDef();
        if (this$varDef == null ? other$varDef != null : !((Object)this$varDef).equals(other$varDef)) {
            return false;
        }
        Set<Symbol> this$varUse = this.getVarUse();
        Set<Symbol> other$varUse = other.getVarUse();
        if (this$varUse == null ? other$varUse != null : !((Object)this$varUse).equals(other$varUse)) {
            return false;
        }
        Set<Symbol> this$methodDef = this.getMethodDef();
        Set<Symbol> other$methodDef = other.getMethodDef();
        if (this$methodDef == null ? other$methodDef != null : !((Object)this$methodDef).equals(other$methodDef)) {
            return false;
        }
        Set<Symbol> this$methodUse = this.getMethodUse();
        Set<Symbol> other$methodUse = other.getMethodUse();
        return !(this$methodUse == null ? other$methodUse != null : !((Object)this$methodUse).equals(other$methodUse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SymbolFrame;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $superName = this.getSuperName();
        result = result * 59 + ($superName == null ? 43 : $superName.hashCode());
        List<String> $interfaces = this.getInterfaces();
        result = result * 59 + ($interfaces == null ? 43 : ((Object)$interfaces).hashCode());
        Set<Symbol> $fieldDef = this.getFieldDef();
        result = result * 59 + ($fieldDef == null ? 43 : ((Object)$fieldDef).hashCode());
        Set<Symbol> $fieldUse = this.getFieldUse();
        result = result * 59 + ($fieldUse == null ? 43 : ((Object)$fieldUse).hashCode());
        Set<Symbol> $varDef = this.getVarDef();
        result = result * 59 + ($varDef == null ? 43 : ((Object)$varDef).hashCode());
        Set<Symbol> $varUse = this.getVarUse();
        result = result * 59 + ($varUse == null ? 43 : ((Object)$varUse).hashCode());
        Set<Symbol> $methodDef = this.getMethodDef();
        result = result * 59 + ($methodDef == null ? 43 : ((Object)$methodDef).hashCode());
        Set<Symbol> $methodUse = this.getMethodUse();
        result = result * 59 + ($methodUse == null ? 43 : ((Object)$methodUse).hashCode());
        return result;
    }

    public String toString() {
        return "SymbolFrame(className=" + this.getClassName() + ", superName=" + this.getSuperName() + ", interfaces=" + this.getInterfaces() + ", fieldDef=" + this.getFieldDef() + ", fieldUse=" + this.getFieldUse() + ", varDef=" + this.getVarDef() + ", varUse=" + this.getVarUse() + ", methodDef=" + this.getMethodDef() + ", methodUse=" + this.getMethodUse() + ")";
    }
}

