/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.impl.obfuscator;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.ClassNode;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.api.impl.obfuscator.frame.SymbolFrame;
import zju.cst.aces.api.impl.obfuscator.util.ASMParser;
import zju.cst.aces.api.impl.obfuscator.util.SymbolAnalyzer;
import zju.cst.aces.dto.PromptInfo;
import zju.cst.aces.dto.TestMessage;
import zju.cst.aces.parser.ProjectParser;

public class Obfuscator {
    public final Config config;
    private Map<String, String> cryptoMap;
    private Map<String, String> reversedMap;
    private Map<String, String> allCaseMap;
    private SymbolFrame symbolFrame;
    private int shift = 1;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public List<String> targetGroupIds;

    public Obfuscator(Config config) {
        this.config = config;
        this.cryptoMap = new TreeMap<String, String>((s1, s2) -> {
            int diff = s2.length() - s1.length();
            if (diff != 0) {
                return diff;
            }
            return s2.compareTo((String)s1);
        });
        this.setTargetGroupIds(config);
    }

    public void setTargetGroupIds(Config config) {
        String projectGroupId = config.getProject().getGroupId();
        List groupIds = Arrays.stream(config.getObfuscateGroupIds()).map(String::trim).collect(Collectors.toList());
        if (!groupIds.contains(projectGroupId)) {
            groupIds.add(projectGroupId);
        }
        this.targetGroupIds = groupIds;
    }

    public PromptInfo obfuscatePromptInfo(PromptInfo promptInfo) {
        this.symbolFrame = this.findSymbolFrameByClass(promptInfo.getFullClassName());
        if (this.symbolFrame == null) {
            throw new RuntimeException("Cannot find symbol frame for class: " + promptInfo.getFullClassName());
        }
        this.symbolFrame.toObNames(this.targetGroupIds).forEach(name -> this.encryptName((String)name));
        promptInfo.setContext(this.obfuscateJava(promptInfo.getContext()));
        promptInfo.setUnitTest(this.obfuscateJava(promptInfo.getUnitTest()));
        promptInfo.setConstructorDeps(this.obfuscateDep(promptInfo.getConstructorDeps()));
        promptInfo.setMethodDeps(this.obfuscateDep(promptInfo.getMethodDeps()));
        promptInfo.setErrorMsg(this.obfuscateTestMessage(promptInfo.getErrorMsg()));
        promptInfo.setClassName(this.obfuscateName(promptInfo.getClassName()));
        promptInfo.setMethodName(this.obfuscateName(promptInfo.getMethodName()));
        promptInfo.setMethodSignature(this.obfuscateMethodSig(promptInfo.getMethodSignature()));
        this.reversedMap = this.createReversedMap(this.cryptoMap);
        this.allCaseMap = this.createAllCaseMap(this.reversedMap);
        return promptInfo;
    }

    public String obfuscateMethodBrief(String brief) {
        try {
            BodyDeclaration md = StaticJavaParser.parseBodyDeclaration((String)brief);
            md.accept((VoidVisitor)new ObfuscatorVisitor(), null);
            return md.toString().substring(0, md.toString().lastIndexOf("{"));
        }
        catch (Exception e) {
            this.config.getLog().error("Failed to obfuscate method brief: " + e);
            return brief;
        }
    }

    public String obfuscateMethodSig(String methodSig) {
        return this.obfuscateString(methodSig);
    }

    public String obfuscateMethod(String code) {
        if (code == "") {
            return "";
        }
        String obfuscatedCode = "";
        try {
            BodyDeclaration md = StaticJavaParser.parseBodyDeclaration((String)code);
            md.accept((VoidVisitor)new ObfuscatorVisitor(), null);
            obfuscatedCode = md.toString();
        }
        catch (Exception e) {
            this.config.getLog().error("Failed to obfuscate method source code: " + e);
        }
        return obfuscatedCode;
    }

    public String obfuscateJava(String code) {
        if (code == "") {
            return "";
        }
        String obfuscatedCode = "";
        try {
            NodeList imports;
            CompilationUnit cu = StaticJavaParser.parse((String)code);
            PackageDeclaration pd = cu.getPackageDeclaration().orElse(null);
            if (pd != null) {
                String packageName = pd.getNameAsString();
                String obfuscatedPackage = Arrays.stream(packageName.split("\\.")).map(this::caesarCipher).collect(Collectors.joining("."));
                this.putCryptoMap(packageName, obfuscatedPackage);
                pd.setName(obfuscatedPackage);
            }
            if ((imports = cu.getImports()) != null) {
                imports.forEach(id -> {
                    if (SymbolFrame.isInGroup(id.toString(), this.targetGroupIds)) {
                        String importName = id.getNameAsString();
                        String obfuscatedId = Arrays.stream(importName.split("\\.")).map(this::caesarCipher).collect(Collectors.joining("."));
                        id.setName(obfuscatedId);
                        this.putCryptoMap(importName, obfuscatedId);
                    }
                });
            }
            cu.accept((VoidVisitor)new ObfuscatorVisitor(), null);
            obfuscatedCode = cu.toString();
        }
        catch (Exception e) {
            this.config.getLog().error("Failed to obfuscate code: " + e);
        }
        return obfuscatedCode;
    }

    public String deobfuscateJava(String code) {
        if (code == "") {
            return "";
        }
        String obfuscatedCode = "";
        try {
            CompilationUnit cu = StaticJavaParser.parse((String)code);
            PackageDeclaration pd = (PackageDeclaration)cu.getPackageDeclaration().orElseThrow();
            String packageName = pd.getNameAsString();
            String deobfuscatedPackage = this.decryptName(packageName);
            pd.setName(deobfuscatedPackage);
            NodeList imports = cu.getImports();
            ArrayList toRemove = new ArrayList();
            if (imports != null) {
                imports.forEach(id -> {
                    String importName = id.getNameAsString();
                    String deobfuscatedId = this.decryptName(importName);
                    if (deobfuscatedId.split("\\.")[0].equals(this.encryptName(packageName.split("\\.")[0]))) {
                        toRemove.add(id);
                    } else {
                        id.setName(deobfuscatedId);
                    }
                });
            }
            toRemove.forEach(id -> id.remove());
            cu.accept((VoidVisitor)new DeobfuscatorVisitor(), null);
            obfuscatedCode = cu.toString();
        }
        catch (Exception e) {
            this.config.getLog().error("Failed to deobfuscate code: " + e);
            e.printStackTrace();
        }
        return obfuscatedCode;
    }

    public String obfuscateName(String name) {
        if (name.contains("\\.")) {
            String[] names = name.split("\\.");
            String obfuscatedName = Arrays.stream(names).map(this::caesarCipher).collect(Collectors.joining("."));
            this.putCryptoMap(name, obfuscatedName);
            return obfuscatedName;
        }
        return this.encryptName(name);
    }

    public String deobfuscateName(String name) {
        return this.decryptName(name);
    }

    public String obfuscateSig(String sig) {
        return this.obfuscateString(sig);
    }

    public String deobfuscateSig(String sig) {
        return this.deobfuscateString(sig);
    }

    public String obfuscateText(String text) {
        return this.obfuscateString(text);
    }

    public String deobfuscateText(String text) {
        return this.deobfuscateString(text);
    }

    public String obfuscateString(String str) {
        if (this.cryptoMap.size() == 0) {
            throw new RuntimeException("Crypto map is empty! Must run obfuscateJava first!");
        }
        try {
            for (String key : this.cryptoMap.keySet()) {
                str = str.replaceAll(Obfuscator.capitalize(key), Obfuscator.capitalize(this.cryptoMap.get(key)));
                str = str.replaceAll(Obfuscator.decapitalize(key), Obfuscator.decapitalize(this.cryptoMap.get(key)));
            }
        }
        catch (Exception e) {
            this.config.getLog().error("Failed to obfuscate String: " + e);
        }
        return str;
    }

    public String deobfuscateString(String str) {
        if (this.cryptoMap.size() == 0) {
            throw new RuntimeException("Crypto map is empty! Must run obfuscateJava first!");
        }
        try {
            for (String key : this.cryptoMap.keySet()) {
                if (key.length() < 4) continue;
                str = str.replaceAll(Obfuscator.capitalize(this.cryptoMap.get(key)), Obfuscator.capitalize(key));
                str = str.replaceAll(Obfuscator.decapitalize(this.cryptoMap.get(key)), Obfuscator.decapitalize(key));
            }
        }
        catch (Exception e) {
            this.config.getLog().error("Failed to deobfuscate String: " + e);
        }
        return str;
    }

    public Map<String, String> obfuscateDep(Map<String, String> dep) {
        HashMap<String, String> obfuscatedDep = new HashMap<String, String>();
        for (String key : dep.keySet()) {
            SymbolFrame sf = this.findSymbolFrameByClass(key);
            if (sf == null) continue;
            sf.toObNames(this.targetGroupIds).forEach(name -> this.encryptName((String)name));
            obfuscatedDep.put(this.obfuscateName(key), this.obfuscateJava(dep.get(key)));
        }
        return obfuscatedDep;
    }

    public Map<String, String> deobfuscateDep(Map<String, String> dep) {
        HashMap<String, String> deobfuscatedDep = new HashMap<String, String>();
        for (String key : dep.keySet()) {
            deobfuscatedDep.put(this.deobfuscateName(key), this.deobfuscateJava(dep.get(key)));
        }
        return deobfuscatedDep;
    }

    public TestMessage obfuscateTestMessage(TestMessage msg) {
        if (msg == null) {
            return null;
        }
        msg.setErrorMessage(msg.getErrorMessage().stream().map(this::obfuscateText).collect(Collectors.toList()));
        return msg;
    }

    public TestMessage deobfuscateTestMessage(TestMessage msg) {
        if (msg == null) {
            return null;
        }
        msg.setErrorMessage(msg.getErrorMessage().stream().map(this::deobfuscateText).collect(Collectors.toList()));
        return msg;
    }

    private String encryptName(String oldName) {
        if (this.symbolFrame == null) {
            throw new RuntimeException("Symbol frames are not initialized!");
        }
        if (this.cryptoMap.containsKey(oldName)) {
            return this.cryptoMap.get(oldName);
        }
        if (oldName.length() < 4) {
            return oldName;
        }
        if (oldName.startsWith("set") || oldName.startsWith("get") || oldName.startsWith("is") || oldName.startsWith("has")) {
            String prefix = "";
            prefix = oldName.startsWith("is") ? oldName.substring(0, 2) : oldName.substring(0, 3);
            String suffix = oldName.substring(prefix.length());
            String newName = prefix + this.caesarCipher(suffix);
            this.putCryptoMap(oldName, newName);
            return newName;
        }
        String newName = this.caesarCipher(oldName);
        this.putCryptoMap(oldName, newName);
        return newName;
    }

    private String encryptIfExist(String oldName) {
        if (this.symbolFrame == null) {
            throw new RuntimeException("Symbol frames are not initialized!");
        }
        if (this.cryptoMap.containsKey(oldName)) {
            return this.cryptoMap.get(oldName);
        }
        return oldName;
    }

    private String caesarCipher(String old) {
        StringBuilder sb = new StringBuilder();
        for (char c : old.toCharArray()) {
            if (c >= 'a' && c < 'z' || c >= 'A' && c < 'Z') {
                sb.append((char)(c + this.shift));
                continue;
            }
            if (c == 'z') {
                sb.append('a');
                continue;
            }
            if (c == 'Z') {
                sb.append('A');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String decryptName(String oldName) {
        if (this.reversedMap == null) {
            this.reversedMap = this.createReversedMap(this.cryptoMap);
        }
        if (this.allCaseMap == null) {
            this.allCaseMap = this.createAllCaseMap(this.reversedMap);
        }
        if (this.allCaseMap.containsKey(oldName)) {
            return this.allCaseMap.get(oldName);
        }
        return oldName;
    }

    public Map<String, SymbolFrame> generateSymbolFrames() {
        HashSet<ClassNode> candidateClasses = new HashSet<ClassNode>();
        ASMParser asmParser = new ASMParser(this.config);
        HashMap<String, SymbolFrame> symbolFrames = new HashMap<String, SymbolFrame>();
        try {
            Path artifactPath = this.config.getProject().getArtifactPath();
            JarFile projectJar = new JarFile(artifactPath.toString());
            candidateClasses.addAll(asmParser.loadClasses(projectJar));
            for (ClassNode classNode : candidateClasses) {
                String className = classNode.name;
                if (!SymbolFrame.isClassInGroup(className, this.targetGroupIds)) continue;
                SymbolAnalyzer analyzer = new SymbolAnalyzer();
                SymbolFrame frame = analyzer.analyze(classNode);
                frame.filterSymbolsByGroupId(this.targetGroupIds);
                String packageDecl = className.substring(0, className.lastIndexOf("/")).replace("/", ".");
                String name = className.contains("$") ? className.substring(className.lastIndexOf("$") + 1) : className.substring(className.lastIndexOf("/") + 1);
                symbolFrames.put(packageDecl + "." + name, frame);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("In Obfuscator.generateSymbolFrames: " + e);
        }
        return symbolFrames;
    }

    public void exportSymbolFrame() {
        ProjectParser.exportJson(this.config.getSymbolFramePath(), this.generateSymbolFrames());
    }

    public SymbolFrame findSymbolFrameByClass(String fullClassName) {
        try {
            Map symbolFrames = (Map)GSON.fromJson(Files.readString(this.config.getSymbolFramePath(), StandardCharsets.UTF_8), new TypeToken<Map<String, SymbolFrame>>(){}.getType());
            return (SymbolFrame)symbolFrames.get(fullClassName);
        }
        catch (IOException e) {
            throw new RuntimeException("In Obfuscator.findSymbolFrameByClass: " + e);
        }
    }

    public void putCryptoMap(String k, String v) {
        this.cryptoMap.put(k, v);
    }

    private Map<String, String> createReversedMap(Map<String, String> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(String::length).reversed().thenComparing(Comparator.reverseOrder()))).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private Map<String, String> createAllCaseMap(Map<String, String> map) {
        HashMap<String, String> allCaseMap = new HashMap<String, String>();
        for (String key : map.keySet()) {
            allCaseMap.put(Obfuscator.capitalize(key), Obfuscator.capitalize(map.get(key)));
            allCaseMap.put(Obfuscator.decapitalize(key), Obfuscator.decapitalize(map.get(key)));
        }
        return allCaseMap;
    }

    public static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String decapitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public Config getConfig() {
        return this.config;
    }

    public Map<String, String> getCryptoMap() {
        return this.cryptoMap;
    }

    public Map<String, String> getReversedMap() {
        return this.reversedMap;
    }

    public Map<String, String> getAllCaseMap() {
        return this.allCaseMap;
    }

    public SymbolFrame getSymbolFrame() {
        return this.symbolFrame;
    }

    public int getShift() {
        return this.shift;
    }

    public List<String> getTargetGroupIds() {
        return this.targetGroupIds;
    }

    public void setCryptoMap(Map<String, String> cryptoMap) {
        this.cryptoMap = cryptoMap;
    }

    public void setReversedMap(Map<String, String> reversedMap) {
        this.reversedMap = reversedMap;
    }

    public void setAllCaseMap(Map<String, String> allCaseMap) {
        this.allCaseMap = allCaseMap;
    }

    public void setSymbolFrame(SymbolFrame symbolFrame) {
        this.symbolFrame = symbolFrame;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Obfuscator)) {
            return false;
        }
        Obfuscator other = (Obfuscator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getShift() != other.getShift()) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        Map<String, String> this$cryptoMap = this.getCryptoMap();
        Map<String, String> other$cryptoMap = other.getCryptoMap();
        if (this$cryptoMap == null ? other$cryptoMap != null : !((Object)this$cryptoMap).equals(other$cryptoMap)) {
            return false;
        }
        Map<String, String> this$reversedMap = this.getReversedMap();
        Map<String, String> other$reversedMap = other.getReversedMap();
        if (this$reversedMap == null ? other$reversedMap != null : !((Object)this$reversedMap).equals(other$reversedMap)) {
            return false;
        }
        Map<String, String> this$allCaseMap = this.getAllCaseMap();
        Map<String, String> other$allCaseMap = other.getAllCaseMap();
        if (this$allCaseMap == null ? other$allCaseMap != null : !((Object)this$allCaseMap).equals(other$allCaseMap)) {
            return false;
        }
        SymbolFrame this$symbolFrame = this.getSymbolFrame();
        SymbolFrame other$symbolFrame = other.getSymbolFrame();
        if (this$symbolFrame == null ? other$symbolFrame != null : !((Object)this$symbolFrame).equals(other$symbolFrame)) {
            return false;
        }
        List<String> this$targetGroupIds = this.getTargetGroupIds();
        List<String> other$targetGroupIds = other.getTargetGroupIds();
        return !(this$targetGroupIds == null ? other$targetGroupIds != null : !((Object)this$targetGroupIds).equals(other$targetGroupIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Obfuscator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getShift();
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        Map<String, String> $cryptoMap = this.getCryptoMap();
        result = result * 59 + ($cryptoMap == null ? 43 : ((Object)$cryptoMap).hashCode());
        Map<String, String> $reversedMap = this.getReversedMap();
        result = result * 59 + ($reversedMap == null ? 43 : ((Object)$reversedMap).hashCode());
        Map<String, String> $allCaseMap = this.getAllCaseMap();
        result = result * 59 + ($allCaseMap == null ? 43 : ((Object)$allCaseMap).hashCode());
        SymbolFrame $symbolFrame = this.getSymbolFrame();
        result = result * 59 + ($symbolFrame == null ? 43 : ((Object)$symbolFrame).hashCode());
        List<String> $targetGroupIds = this.getTargetGroupIds();
        result = result * 59 + ($targetGroupIds == null ? 43 : ((Object)$targetGroupIds).hashCode());
        return result;
    }

    public String toString() {
        return "Obfuscator(config=" + this.getConfig() + ", cryptoMap=" + this.getCryptoMap() + ", reversedMap=" + this.getReversedMap() + ", allCaseMap=" + this.getAllCaseMap() + ", symbolFrame=" + this.getSymbolFrame() + ", shift=" + this.getShift() + ", targetGroupIds=" + this.getTargetGroupIds() + ")";
    }

    private class DeobfuscatorVisitor
    extends VoidVisitorAdapter<Void> {
        private DeobfuscatorVisitor() {
        }

        public void visit(ClassOrInterfaceDeclaration n, Void arg) {
            String className = n.getNameAsString();
            if (className.contains("Test")) {
                n.setName(Obfuscator.this.decryptName(className.replace("Test", "")) + "Test");
            }
            super.visit(n, (Object)arg);
        }

        public void visit(MethodDeclaration n, Void arg) {
            String methodName = n.getNameAsString();
            n.setName(Obfuscator.this.deobfuscateString(methodName));
            super.visit(n, (Object)arg);
        }

        public void visit(StringLiteralExpr n, Void arg) {
            n.setValue(Obfuscator.this.deobfuscateString(n.getValue()));
            super.visit(n, (Object)arg);
        }

        public void visit(LineComment n, Void arg) {
            n.setContent(Obfuscator.this.deobfuscateString(n.getContent()));
            super.visit(n, (Object)arg);
        }

        public void visit(SimpleName n, Void arg) {
            n.setIdentifier(Obfuscator.this.decryptName(n.getIdentifier()));
            super.visit(n, (Object)arg);
        }

        public void visit(MethodReferenceExpr n, Void arg) {
            n.setIdentifier(Obfuscator.this.decryptName(n.getIdentifier()));
            super.visit(n, (Object)arg);
        }
    }

    private class ObfuscatorVisitor
    extends VoidVisitorAdapter<Void> {
        private ObfuscatorVisitor() {
        }

        public void visit(SimpleName n, Void arg) {
            n.setIdentifier(Obfuscator.this.encryptIfExist(n.getIdentifier()));
            super.visit(n, (Object)arg);
        }

        public void visit(MethodReferenceExpr n, Void arg) {
            n.setIdentifier(Obfuscator.this.encryptIfExist(n.getIdentifier()));
            super.visit(n, (Object)arg);
        }
    }
}

