/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.impl;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import java.nio.file.Path;
import java.util.List;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import zju.cst.aces.api.Validator;
import zju.cst.aces.dto.PromptInfo;
import zju.cst.aces.util.TestCompiler;

public class ValidatorImpl
implements Validator {
    TestCompiler compiler;

    public ValidatorImpl(Path testOutputPath, Path compileOutputPath, Path targetPath, List<String> classpathElements) {
        this.compiler = new TestCompiler(testOutputPath, compileOutputPath, targetPath, classpathElements);
    }

    @Override
    public boolean syntacticValidate(String code) {
        try {
            StaticJavaParser.parse((String)code);
            return true;
        }
        catch (ParseProblemException e) {
            return false;
        }
    }

    @Override
    public boolean semanticValidate(String code, String className, Path outputPath, PromptInfo promptInfo) {
        this.compiler.setCode(code);
        return this.compiler.compileTest(className, outputPath, promptInfo);
    }

    @Override
    public boolean runtimeValidate(String fullTestName) {
        return this.compiler.executeTest(fullTestName).getTestsFailedCount() == 0L;
    }

    @Override
    public boolean compile(String className, Path outputPath, PromptInfo promptInfo) {
        return this.compiler.compileTest(className, outputPath, promptInfo);
    }

    @Override
    public TestExecutionSummary execute(String fullTestName) {
        return this.compiler.executeTest(fullTestName);
    }

    public TestCompiler getCompiler() {
        return this.compiler;
    }

    public void setCompiler(TestCompiler compiler) {
        this.compiler = compiler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidatorImpl)) {
            return false;
        }
        ValidatorImpl other = (ValidatorImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TestCompiler this$compiler = this.getCompiler();
        TestCompiler other$compiler = other.getCompiler();
        return !(this$compiler == null ? other$compiler != null : !((Object)this$compiler).equals(other$compiler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidatorImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TestCompiler $compiler = this.getCompiler();
        result = result * 59 + ($compiler == null ? 43 : ((Object)$compiler).hashCode());
        return result;
    }

    public String toString() {
        return "ValidatorImpl(compiler=" + this.getCompiler() + ")";
    }
}

