/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.impl;

import zju.cst.aces.api.Repair;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.api.impl.ChatGenerator;
import zju.cst.aces.api.impl.PromptConstructorImpl;
import zju.cst.aces.dto.ChatResponse;
import zju.cst.aces.dto.PromptInfo;
import zju.cst.aces.runner.AbstractRunner;
import zju.cst.aces.runner.MethodRunner;

public class RepairImpl
implements Repair {
    Config config;
    PromptConstructorImpl promptConstructorImpl;
    boolean success = false;

    public RepairImpl(Config config, PromptConstructorImpl promptConstructorImpl) {
        this.config = config;
        this.promptConstructorImpl = promptConstructorImpl;
    }

    @Override
    public String ruleBasedRepair(String code) {
        code = AbstractRunner.changeTestName(code, this.promptConstructorImpl.getTestName());
        code = AbstractRunner.repairPackage(code, this.promptConstructorImpl.getPromptInfo().getClassInfo().getPackageName());
        code = AbstractRunner.repairImports(code, this.promptConstructorImpl.getPromptInfo().getClassInfo().getImports());
        return code;
    }

    @Override
    public String LLMBasedRepair(String code, int rounds) {
        PromptInfo promptInfo = this.promptConstructorImpl.getPromptInfo();
        promptInfo.setUnitTest(code);
        String fullClassName = promptInfo.getClassInfo().getPackageName() + "." + promptInfo.getClassInfo().getClassName();
        if (MethodRunner.runTest(this.config, this.promptConstructorImpl.getFullTestName(), promptInfo, rounds)) {
            this.success = true;
            return code;
        }
        this.promptConstructorImpl.generate();
        if (this.promptConstructorImpl.isExceedMaxTokens()) {
            this.config.getLog().error("Exceed max prompt tokens: " + promptInfo.methodInfo.methodName + " Skipped.");
            return code;
        }
        ChatResponse response = ChatGenerator.chat(this.config, this.promptConstructorImpl.getMessages());
        String newcode = ChatGenerator.extractCodeByResponse(response);
        if (newcode.isEmpty()) {
            this.config.getLog().warn("Test for method < " + promptInfo.methodInfo.methodName + " > extract code failed");
            return code;
        }
        return newcode;
    }

    @Override
    public String LLMBasedRepair(String code) {
        PromptInfo promptInfo = this.promptConstructorImpl.getPromptInfo();
        promptInfo.setUnitTest(code);
        String fullClassName = promptInfo.getClassInfo().getPackageName() + "." + promptInfo.getClassInfo().getClassName();
        if (MethodRunner.runTest(this.config, this.promptConstructorImpl.getFullTestName(), promptInfo, 0)) {
            this.config.getLog().info("Test for method < " + promptInfo.methodInfo.methodName + " > doesn't need repair");
            return code;
        }
        this.promptConstructorImpl.generate();
        if (this.promptConstructorImpl.isExceedMaxTokens()) {
            this.config.getLog().error("Exceed max prompt tokens: " + promptInfo.methodInfo.methodName + " Skipped.");
            return code;
        }
        ChatResponse response = ChatGenerator.chat(this.config, this.promptConstructorImpl.getMessages());
        String newcode = ChatGenerator.extractCodeByResponse(response);
        if (newcode.isEmpty()) {
            this.config.getLog().warn("Test for method < " + promptInfo.methodInfo.methodName + " > extract code failed");
            return code;
        }
        return newcode;
    }

    public Config getConfig() {
        return this.config;
    }

    public PromptConstructorImpl getPromptConstructorImpl() {
        return this.promptConstructorImpl;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setPromptConstructorImpl(PromptConstructorImpl promptConstructorImpl) {
        this.promptConstructorImpl = promptConstructorImpl;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepairImpl)) {
            return false;
        }
        RepairImpl other = (RepairImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        PromptConstructorImpl this$promptConstructorImpl = this.getPromptConstructorImpl();
        PromptConstructorImpl other$promptConstructorImpl = other.getPromptConstructorImpl();
        return !(this$promptConstructorImpl == null ? other$promptConstructorImpl != null : !((Object)this$promptConstructorImpl).equals(other$promptConstructorImpl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepairImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        PromptConstructorImpl $promptConstructorImpl = this.getPromptConstructorImpl();
        result = result * 59 + ($promptConstructorImpl == null ? 43 : ((Object)$promptConstructorImpl).hashCode());
        return result;
    }

    public String toString() {
        return "RepairImpl(config=" + this.getConfig() + ", promptConstructorImpl=" + this.getPromptConstructorImpl() + ", success=" + this.isSuccess() + ")";
    }
}

