/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.impl;

import java.io.IOException;
import java.util.List;
import zju.cst.aces.api.PromptConstructor;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.dto.ClassInfo;
import zju.cst.aces.dto.Message;
import zju.cst.aces.dto.MethodInfo;
import zju.cst.aces.dto.PromptInfo;
import zju.cst.aces.prompt.PromptGenerator;
import zju.cst.aces.runner.AbstractRunner;
import zju.cst.aces.util.TokenCounter;

public class PromptConstructorImpl
implements PromptConstructor {
    Config config;
    PromptInfo promptInfo;
    List<Message> messages;
    int tokenCount = 0;
    String testName;
    String fullTestName;
    static final String separator = "_";

    public PromptConstructorImpl(Config config) {
        this.config = config;
    }

    @Override
    public List<Message> generate() {
        try {
            if (this.promptInfo == null) {
                throw new RuntimeException("PromptInfo is null, you need to initialize it first.");
            }
            this.messages = new PromptGenerator(this.config).generateMessages(this.promptInfo);
            this.countToken();
            return this.messages;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPromptInfoWithDep(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        this.promptInfo = AbstractRunner.generatePromptInfoWithDep(this.config, classInfo, methodInfo);
    }

    public void setPromptInfoWithoutDep(ClassInfo classInfo, MethodInfo methodInfo) throws IOException {
        this.promptInfo = AbstractRunner.generatePromptInfoWithoutDep(this.config, classInfo, methodInfo);
    }

    public void setFullTestName(String fullTestName) {
        this.fullTestName = fullTestName;
        this.testName = fullTestName.substring(fullTestName.lastIndexOf(".") + 1);
        this.promptInfo.setFullTestName(this.fullTestName);
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void countToken() {
        for (Message p : this.messages) {
            this.tokenCount += TokenCounter.countToken(p.getContent());
        }
    }

    public boolean isExceedMaxTokens() {
        return this.tokenCount > this.config.maxPromptTokens;
    }

    public Config getConfig() {
        return this.config;
    }

    public PromptInfo getPromptInfo() {
        return this.promptInfo;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getFullTestName() {
        return this.fullTestName;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setPromptInfo(PromptInfo promptInfo) {
        this.promptInfo = promptInfo;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setTokenCount(int tokenCount) {
        this.tokenCount = tokenCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PromptConstructorImpl)) {
            return false;
        }
        PromptConstructorImpl other = (PromptConstructorImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTokenCount() != other.getTokenCount()) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        PromptInfo this$promptInfo = this.getPromptInfo();
        PromptInfo other$promptInfo = other.getPromptInfo();
        if (this$promptInfo == null ? other$promptInfo != null : !((Object)this$promptInfo).equals(other$promptInfo)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$testName = this.getTestName();
        String other$testName = other.getTestName();
        if (this$testName == null ? other$testName != null : !this$testName.equals(other$testName)) {
            return false;
        }
        String this$fullTestName = this.getFullTestName();
        String other$fullTestName = other.getFullTestName();
        return !(this$fullTestName == null ? other$fullTestName != null : !this$fullTestName.equals(other$fullTestName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PromptConstructorImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTokenCount();
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        PromptInfo $promptInfo = this.getPromptInfo();
        result = result * 59 + ($promptInfo == null ? 43 : ((Object)$promptInfo).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $testName = this.getTestName();
        result = result * 59 + ($testName == null ? 43 : $testName.hashCode());
        String $fullTestName = this.getFullTestName();
        result = result * 59 + ($fullTestName == null ? 43 : $fullTestName.hashCode());
        return result;
    }

    public String toString() {
        return "PromptConstructorImpl(config=" + this.getConfig() + ", promptInfo=" + this.getPromptInfo() + ", messages=" + this.getMessages() + ", tokenCount=" + this.getTokenCount() + ", testName=" + this.getTestName() + ", fullTestName=" + this.getFullTestName() + ")";
    }
}

