/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.impl;

import zju.cst.aces.api.PreProcess;
import zju.cst.aces.api.Task;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.parser.ProjectParser;

public class Parser
implements PreProcess {
    ProjectParser parser;
    Config config;

    public Parser(Config config) {
        this.config = config;
        this.parser = new ProjectParser(config);
    }

    @Override
    public void process() {
        this.parse();
    }

    public void parse() {
        try {
            Task.checkTargetFolder(this.config.getProject());
        }
        catch (RuntimeException e) {
            this.config.getLog().error(e.toString());
            return;
        }
        if (this.config.getProject().getPackaging().equals("pom")) {
            this.config.getLog().info("\n==========================\n[ChatUniTest] Skip pom-packaging ...");
            return;
        }
        if (!this.config.getParseOutput().toFile().exists()) {
            this.config.getLog().info("\n==========================\n[ChatUniTest] Parsing class info ...");
            this.parser.parse();
            this.config.getLog().info("\n==========================\n[ChatUniTest] Parse finished");
        } else {
            this.config.getLog().info("\n==========================\n[ChatUniTest] Parse output already exists, skip parsing!");
        }
    }

    public ProjectParser getParser() {
        return this.parser;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setParser(ProjectParser parser) {
        this.parser = parser;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parser)) {
            return false;
        }
        Parser other = (Parser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProjectParser this$parser = this.getParser();
        ProjectParser other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Parser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProjectParser $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    public String toString() {
        return "Parser(parser=" + this.getParser() + ", config=" + this.getConfig() + ")";
    }
}

