/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api.config;

public class ModelConfig {
    public String modelName;
    public String url;
    public int contextLength;
    public double temperature;
    public int frequencyPenalty;
    public int presencePenalty;

    private ModelConfig(Builder builder) {
        this.modelName = builder.modelName;
        this.url = builder.url;
        this.contextLength = builder.contextLength;
        this.temperature = builder.temperature;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.presencePenalty = builder.presencePenalty;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getUrl() {
        return this.url;
    }

    public int getContextLength() {
        return this.contextLength;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public int getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public int getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setContextLength(int contextLength) {
        this.contextLength = contextLength;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public void setFrequencyPenalty(int frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public void setPresencePenalty(int presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelConfig)) {
            return false;
        }
        ModelConfig other = (ModelConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContextLength() != other.getContextLength()) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (this.getFrequencyPenalty() != other.getFrequencyPenalty()) {
            return false;
        }
        if (this.getPresencePenalty() != other.getPresencePenalty()) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContextLength();
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        result = result * 59 + this.getFrequencyPenalty();
        result = result * 59 + this.getPresencePenalty();
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String toString() {
        return "ModelConfig(modelName=" + this.getModelName() + ", url=" + this.getUrl() + ", contextLength=" + this.getContextLength() + ", temperature=" + this.getTemperature() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", presencePenalty=" + this.getPresencePenalty() + ")";
    }

    public static class Builder {
        private String modelName = "gpt-3.5-turbo";
        private String url = "https://api.openai.com/v1/chat/completions";
        private int contextLength = 4096;
        private double temperature = 0.5;
        private int frequencyPenalty = 0;
        private int presencePenalty = 0;

        public Builder withModelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withContextLength(int contextLength) {
            this.contextLength = contextLength;
            return this;
        }

        public Builder withPresencePenalty(int penalty) {
            this.presencePenalty = penalty;
            return this;
        }

        public Builder withFrequencyPenalty(int penalty) {
            this.frequencyPenalty = penalty;
            return this;
        }

        public Builder withTemperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ModelConfig build() {
            return new ModelConfig(this);
        }
    }
}

