/*
 * Decompiled with CFR 0.152.
 */
package zju.cst.aces.api;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import zju.cst.aces.api.Logger;
import zju.cst.aces.api.Project;
import zju.cst.aces.api.Runner;
import zju.cst.aces.api.config.Config;
import zju.cst.aces.dto.ClassInfo;
import zju.cst.aces.dto.MethodInfo;
import zju.cst.aces.parser.ProjectParser;
import zju.cst.aces.runner.AbstractRunner;
import zju.cst.aces.util.Counter;

public class Task {
    Config config;
    Logger log;
    Runner runner;

    public Task(Config config, Runner runner) {
        this.config = config;
        this.log = config.getLog();
        this.runner = runner;
    }

    public void startMethodTask(String className, String methodName) {
        try {
            Task.checkTargetFolder(this.config.getProject());
        }
        catch (RuntimeException e) {
            this.log.error(e.toString());
            return;
        }
        if (this.config.getProject().getPackaging().equals("pom")) {
            this.log.info("\n==========================\n[ChatUniTest] Skip pom-packaging ...");
            return;
        }
        ProjectParser parser = new ProjectParser(this.config);
        parser.parse();
        this.log.info("\n==========================\n[ChatUniTest] Generating tests for class: < " + className + "> method: < " + methodName + " > ...");
        try {
            String fullClassName = Task.getFullClassName(this.config, className);
            ClassInfo classInfo = AbstractRunner.getClassInfo(this.config, fullClassName);
            MethodInfo methodInfo = null;
            if (methodName.matches("\\d+")) {
                String methodId = methodName;
                for (String mSig : classInfo.methodSigs.keySet()) {
                    if (!classInfo.methodSigs.get(mSig).equals(methodId)) continue;
                    methodInfo = AbstractRunner.getMethodInfo(this.config, classInfo, mSig);
                    break;
                }
                if (methodInfo == null) {
                    throw new IOException("Method " + methodName + " in class " + fullClassName + " not found");
                }
                try {
                    this.runner.runMethod(fullClassName, methodInfo);
                }
                catch (Exception e) {
                    this.log.error("Error when generating tests for " + methodName + " in " + className + " " + this.config.getProject().getArtifactId() + "\n" + e.getMessage());
                }
            } else {
                for (String mSig : classInfo.methodSigs.keySet()) {
                    if (!mSig.split("\\(")[0].equals(methodName)) continue;
                    methodInfo = AbstractRunner.getMethodInfo(this.config, classInfo, mSig);
                    if (methodInfo == null) {
                        throw new IOException("Method " + methodName + " in class " + fullClassName + " not found");
                    }
                    try {
                        this.runner.runMethod(fullClassName, methodInfo);
                    }
                    catch (Exception e) {
                        this.log.error("Error when generating tests for " + methodName + " in " + className + " " + this.config.getProject().getArtifactId() + "\n" + e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.warn("Method not found: " + methodName + " in " + className + " " + this.config.getProject().getArtifactId());
            return;
        }
        this.log.info("\n==========================\n[ChatUniTest] Generation finished");
    }

    public void startClassTask(String className) {
        try {
            Task.checkTargetFolder(this.config.getProject());
        }
        catch (RuntimeException e) {
            this.log.error(e.toString());
            return;
        }
        if (this.config.getProject().getPackaging().equals("pom")) {
            this.log.info("\n==========================\n[ChatUniTest] Skip pom-packaging ...");
            return;
        }
        ProjectParser parser = new ProjectParser(this.config);
        parser.parse();
        this.log.info("\n==========================\n[ChatUniTest] Generating tests for class < " + className + " > ...");
        try {
            this.runner.runClass(Task.getFullClassName(this.config, className));
        }
        catch (IOException e) {
            this.log.warn("Class not found: " + className + " in " + this.config.getProject().getArtifactId());
        }
        this.log.info("\n==========================\n[ChatUniTest] Generation finished");
    }

    public void startProjectTask() {
        Project project = this.config.getProject();
        try {
            Task.checkTargetFolder(project);
        }
        catch (RuntimeException e) {
            this.log.error(e.toString());
            return;
        }
        if (project.getPackaging().equals("pom")) {
            this.log.info("\n==========================\n[ChatUniTest] Skip pom-packaging ...");
            return;
        }
        ProjectParser parser = new ProjectParser(this.config);
        parser.parse();
        List<String> classPaths = ProjectParser.scanSourceDirectory(project);
        if (this.config.isEnableMultithreading()) {
            this.projectJob(classPaths);
        } else {
            for (String classPath : classPaths) {
                String className = classPath.substring(classPath.lastIndexOf(File.separator) + 1, classPath.lastIndexOf("."));
                try {
                    String fullClassName = Task.getFullClassName(this.config, className);
                    this.log.info("\n==========================\n[ChatUniTest] Generating tests for class < " + className + " > ...");
                    ClassInfo info = AbstractRunner.getClassInfo(this.config, fullClassName);
                    if (!Counter.filter(info)) {
                        this.config.getLog().info("Skip class: " + classPath);
                        continue;
                    }
                    this.runner.runClass(fullClassName);
                }
                catch (IOException e) {
                    this.log.error("[ChatUniTest] Generate tests for class " + className + " failed: " + e);
                }
            }
        }
        this.log.info("\n==========================\n[ChatUniTest] Generation finished");
    }

    public void projectJob(List<String> classPaths) {
        final ExecutorService executor = Executors.newFixedThreadPool(this.config.getClassThreads());
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        for (final String string : classPaths) {
            Callable<String> callable = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String className = string.substring(string.lastIndexOf(File.separator) + 1, string.lastIndexOf("."));
                    try {
                        String fullClassName = Task.getFullClassName(Task.this.config, className);
                        Task.this.log.info("\n==========================\n[ChatUniTest] Generating tests for class < " + className + " > ...");
                        ClassInfo info = AbstractRunner.getClassInfo(Task.this.config, fullClassName);
                        if (!Counter.filter(info)) {
                            return "Skip class: " + string;
                        }
                        Task.this.runner.runClass(fullClassName);
                    }
                    catch (IOException e) {
                        Task.this.log.error("[ChatUniTest] Generate tests for class " + className + " failed: " + e);
                    }
                    return "Processed " + string;
                }
            };
            Future<String> future = executor.submit(callable);
            futures.add(future);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executor.shutdownNow();
            }
        });
        for (Future future : futures) {
            try {
                String result = (String)future.get();
                System.out.println(result);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        executor.shutdown();
    }

    public static String getFullClassName(Config config, String name) throws IOException {
        if (Task.isFullName(name)) {
            return name;
        }
        Path classMapPath = config.getClassNameMapPath();
        Map classMap = (Map)config.getGSON().fromJson(Files.readString(classMapPath, StandardCharsets.UTF_8), Map.class);
        if (classMap.containsKey(name)) {
            if (((List)classMap.get(name)).size() > 1) {
                throw new RuntimeException("[ChatUniTest] Multiple classes Named " + name + ": " + classMap.get(name) + " Please use full qualified name!");
            }
            return (String)((List)classMap.get(name)).get(0);
        }
        return name;
    }

    public static boolean isFullName(String name) {
        return name.contains(".");
    }

    public static void checkTargetFolder(Project project) {
        if (project.getPackaging().equals("pom")) {
            return;
        }
        if (!new File(project.getBuildPath().toString()).exists()) {
            throw new RuntimeException("In ProjectTestMojo.checkTargetFolder: The project is not compiled to the target directory. Please run 'mvn install' first.");
        }
    }
}

