/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismCentral;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismEndpoint;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismEndpointBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.PrismEndpointFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PrismCentralFluent<A extends PrismCentralFluent<A>>
extends BaseFluent<A> {
    private PrismEndpointBuilder endpoint;
    private String password;
    private String username;
    private Map<String, Object> additionalProperties;

    public PrismCentralFluent() {
    }

    public PrismCentralFluent(PrismCentral instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PrismCentral instance) {
        PrismCentral prismCentral = instance = instance != null ? instance : new PrismCentral();
        if (instance != null) {
            this.withEndpoint(instance.getEndpoint());
            this.withPassword(instance.getPassword());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public PrismEndpoint buildEndpoint() {
        return this.endpoint != null ? this.endpoint.build() : null;
    }

    public A withEndpoint(PrismEndpoint endpoint) {
        this._visitables.remove((Object)"endpoint");
        if (endpoint != null) {
            this.endpoint = new PrismEndpointBuilder(endpoint);
            this._visitables.get((Object)"endpoint").add(this.endpoint);
        } else {
            this.endpoint = null;
            this._visitables.get((Object)"endpoint").remove((Object)this.endpoint);
        }
        return (A)((Object)this);
    }

    public boolean hasEndpoint() {
        return this.endpoint != null;
    }

    public A withNewEndpoint(String address, Integer port) {
        return this.withEndpoint(new PrismEndpoint(address, port));
    }

    public EndpointNested<A> withNewEndpoint() {
        return new EndpointNested(null);
    }

    public EndpointNested<A> withNewEndpointLike(PrismEndpoint item) {
        return new EndpointNested(item);
    }

    public EndpointNested<A> editEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(null));
    }

    public EndpointNested<A> editOrNewEndpoint() {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(new PrismEndpointBuilder().build()));
    }

    public EndpointNested<A> editOrNewEndpointLike(PrismEndpoint item) {
        return this.withNewEndpointLike(Optional.ofNullable(this.buildEndpoint()).orElse(item));
    }

    public String getPassword() {
        return this.password;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)((Object)this);
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrismCentralFluent that = (PrismCentralFluent)((Object)o);
        if (!Objects.equals((Object)this.endpoint, (Object)that.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endpoint, this.password, this.username, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endpoint != null) {
            sb.append("endpoint:");
            sb.append((Object)((Object)this.endpoint) + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EndpointNested<N>
    extends PrismEndpointFluent<EndpointNested<N>>
    implements Nested<N> {
        PrismEndpointBuilder builder;

        EndpointNested(PrismEndpoint item) {
            this.builder = new PrismEndpointBuilder(this, item);
        }

        public N and() {
            return (N)PrismCentralFluent.this.withEndpoint(this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }
}

