/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatchFluentImpl;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCMethodMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCMethodMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCMethodMatchFluentImpl;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteMatchFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GRPCRouteMatchFluentImpl<A extends GRPCRouteMatchFluent<A>>
extends BaseFluent<A>
implements GRPCRouteMatchFluent<A> {
    private ArrayList<GRPCHeaderMatchBuilder> headers = new ArrayList();
    private GRPCMethodMatchBuilder method;
    private Map<String, Object> additionalProperties;

    public GRPCRouteMatchFluentImpl() {
    }

    public GRPCRouteMatchFluentImpl(GRPCRouteMatch instance) {
        this.withHeaders(instance.getHeaders());
        this.withMethod(instance.getMethod());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToHeaders(Integer index, GRPCHeaderMatch item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
        this._visitables.get((Object)"headers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"headers").size(), builder);
        this.headers.add(index >= 0 ? index.intValue() : this.headers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHeaders(Integer index, GRPCHeaderMatch item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"headers").size()) {
            this._visitables.get((Object)"headers").add(builder);
        } else {
            this._visitables.get((Object)"headers").set(index, builder);
        }
        if (index < 0 || index >= this.headers.size()) {
            this.headers.add(builder);
        } else {
            this.headers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHeaders(GRPCHeaderMatch ... items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (GRPCHeaderMatch item : items) {
            GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
            this._visitables.get((Object)"headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHeaders(Collection<GRPCHeaderMatch> items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (GRPCHeaderMatch item : items) {
            GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
            this._visitables.get((Object)"headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHeaders(GRPCHeaderMatch ... items) {
        for (GRPCHeaderMatch item : items) {
            GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
            this._visitables.get((Object)"headers").remove(builder);
            if (this.headers == null) continue;
            this.headers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHeaders(Collection<GRPCHeaderMatch> items) {
        for (GRPCHeaderMatch item : items) {
            GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
            this._visitables.get((Object)"headers").remove(builder);
            if (this.headers == null) continue;
            this.headers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHeaders(Predicate<GRPCHeaderMatchBuilder> predicate) {
        if (this.headers == null) {
            return (A)this;
        }
        Iterator<GRPCHeaderMatchBuilder> each = this.headers.iterator();
        List visitables = this._visitables.get((Object)"headers");
        while (each.hasNext()) {
            GRPCHeaderMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GRPCHeaderMatch> getHeaders() {
        return this.headers != null ? GRPCRouteMatchFluentImpl.build(this.headers) : null;
    }

    @Override
    public List<GRPCHeaderMatch> buildHeaders() {
        return this.headers != null ? GRPCRouteMatchFluentImpl.build(this.headers) : null;
    }

    @Override
    public GRPCHeaderMatch buildHeader(Integer index) {
        return this.headers.get(index).build();
    }

    @Override
    public GRPCHeaderMatch buildFirstHeader() {
        return this.headers.get(0).build();
    }

    @Override
    public GRPCHeaderMatch buildLastHeader() {
        return this.headers.get(this.headers.size() - 1).build();
    }

    @Override
    public GRPCHeaderMatch buildMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
        for (GRPCHeaderMatchBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
        for (GRPCHeaderMatchBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHeaders(List<GRPCHeaderMatch> headers) {
        if (this.headers != null) {
            this._visitables.get((Object)"headers").removeAll(this.headers);
        }
        if (headers != null) {
            this.headers = new ArrayList();
            for (GRPCHeaderMatch item : headers) {
                this.addToHeaders(item);
            }
        } else {
            this.headers = null;
        }
        return (A)this;
    }

    @Override
    public A withHeaders(GRPCHeaderMatch ... headers) {
        if (this.headers != null) {
            this.headers.clear();
        }
        if (headers != null) {
            for (GRPCHeaderMatch item : headers) {
                this.addToHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public A addNewHeader(String name, String type, String value) {
        return this.addToHeaders(new GRPCHeaderMatch(name, type, value));
    }

    @Override
    public GRPCRouteMatchFluent.HeadersNested<A> addNewHeader() {
        return new HeadersNestedImpl();
    }

    @Override
    public GRPCRouteMatchFluent.HeadersNested<A> addNewHeaderLike(GRPCHeaderMatch item) {
        return new HeadersNestedImpl(-1, item);
    }

    @Override
    public GRPCRouteMatchFluent.HeadersNested<A> setNewHeaderLike(Integer index, GRPCHeaderMatch item) {
        return new HeadersNestedImpl(index, item);
    }

    @Override
    public GRPCRouteMatchFluent.HeadersNested<A> editHeader(Integer index) {
        if (this.headers.size() <= index) {
            throw new RuntimeException("Can't edit headers. Index exceeds size.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    public GRPCRouteMatchFluent.HeadersNested<A> editFirstHeader() {
        if (this.headers.size() == 0) {
            throw new RuntimeException("Can't edit first headers. The list is empty.");
        }
        return this.setNewHeaderLike(0, this.buildHeader(0));
    }

    @Override
    public GRPCRouteMatchFluent.HeadersNested<A> editLastHeader() {
        int index = this.headers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last headers. The list is empty.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    public GRPCRouteMatchFluent.HeadersNested<A> editMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!predicate.test(this.headers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching headers. No match found.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    @Deprecated
    public GRPCMethodMatch getMethod() {
        return this.method != null ? this.method.build() : null;
    }

    @Override
    public GRPCMethodMatch buildMethod() {
        return this.method != null ? this.method.build() : null;
    }

    @Override
    public A withMethod(GRPCMethodMatch method) {
        this._visitables.get((Object)"method").remove(this.method);
        if (method != null) {
            this.method = new GRPCMethodMatchBuilder(method);
            this._visitables.get((Object)"method").add(this.method);
        } else {
            this.method = null;
            this._visitables.get((Object)"method").remove(this.method);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMethod() {
        return this.method != null;
    }

    @Override
    public A withNewMethod(String method, String service, String type) {
        return this.withMethod(new GRPCMethodMatch(method, service, type));
    }

    @Override
    public GRPCRouteMatchFluent.MethodNested<A> withNewMethod() {
        return new MethodNestedImpl();
    }

    @Override
    public GRPCRouteMatchFluent.MethodNested<A> withNewMethodLike(GRPCMethodMatch item) {
        return new MethodNestedImpl(item);
    }

    @Override
    public GRPCRouteMatchFluent.MethodNested<A> editMethod() {
        return this.withNewMethodLike(this.getMethod());
    }

    @Override
    public GRPCRouteMatchFluent.MethodNested<A> editOrNewMethod() {
        return this.withNewMethodLike(this.getMethod() != null ? this.getMethod() : new GRPCMethodMatchBuilder().build());
    }

    @Override
    public GRPCRouteMatchFluent.MethodNested<A> editOrNewMethodLike(GRPCMethodMatch item) {
        return this.withNewMethodLike(this.getMethod() != null ? this.getMethod() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GRPCRouteMatchFluentImpl that = (GRPCRouteMatchFluentImpl)o;
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.method, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.method != null) {
            sb.append("method:");
            sb.append(this.method + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MethodNestedImpl<N>
    extends GRPCMethodMatchFluentImpl<GRPCRouteMatchFluent.MethodNested<N>>
    implements GRPCRouteMatchFluent.MethodNested<N>,
    Nested<N> {
        GRPCMethodMatchBuilder builder;

        MethodNestedImpl(GRPCMethodMatch item) {
            this.builder = new GRPCMethodMatchBuilder(this, item);
        }

        MethodNestedImpl() {
            this.builder = new GRPCMethodMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)GRPCRouteMatchFluentImpl.this.withMethod(this.builder.build());
        }

        @Override
        public N endMethod() {
            return this.and();
        }
    }

    class HeadersNestedImpl<N>
    extends GRPCHeaderMatchFluentImpl<GRPCRouteMatchFluent.HeadersNested<N>>
    implements GRPCRouteMatchFluent.HeadersNested<N>,
    Nested<N> {
        GRPCHeaderMatchBuilder builder;
        Integer index;

        HeadersNestedImpl(Integer index, GRPCHeaderMatch item) {
            this.index = index;
            this.builder = new GRPCHeaderMatchBuilder(this, item);
        }

        HeadersNestedImpl() {
            this.index = -1;
            this.builder = new GRPCHeaderMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)GRPCRouteMatchFluentImpl.this.setToHeaders(this.index, this.builder.build());
        }

        @Override
        public N endHeader() {
            return this.and();
        }
    }
}

