/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentImpl;
import java.util.Objects;

public class ResourceQuotaSpecBuilder
extends ResourceQuotaSpecFluentImpl<ResourceQuotaSpecBuilder>
implements VisitableBuilder<ResourceQuotaSpec, ResourceQuotaSpecBuilder> {
    ResourceQuotaSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceQuotaSpecBuilder() {
        this(false);
    }

    public ResourceQuotaSpecBuilder(Boolean validationEnabled) {
        this(new ResourceQuotaSpec(), validationEnabled);
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceQuotaSpec(), validationEnabled);
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent, ResourceQuotaSpec instance) {
        this(fluent, instance, false);
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpecFluent<?> fluent, ResourceQuotaSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHard(instance.getHard());
        fluent.withScopeSelector(instance.getScopeSelector());
        fluent.withScopes(instance.getScopes());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpec instance) {
        this(instance, (Boolean)false);
    }

    public ResourceQuotaSpecBuilder(ResourceQuotaSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHard(instance.getHard());
        this.withScopeSelector(instance.getScopeSelector());
        this.withScopes(instance.getScopes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceQuotaSpec build() {
        ResourceQuotaSpec buildable = new ResourceQuotaSpec(this.fluent.getHard(), this.fluent.getScopeSelector(), this.fluent.getScopes());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaSpecBuilder that = (ResourceQuotaSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

