/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarUnArchiver;

public enum ArchiveCompression {
    none(TarArchiver.TarCompressionMethod.none, TarUnArchiver.UntarCompressionMethod.NONE, "tar"),
    gzip(TarArchiver.TarCompressionMethod.gzip, TarUnArchiver.UntarCompressionMethod.GZIP, "tar.gz"){

        @Override
        public OutputStream wrapOutputStream(OutputStream out) throws IOException {
            return new GZIPOutputStream(out);
        }
    }
    ,
    bzip2(TarArchiver.TarCompressionMethod.bzip2, TarUnArchiver.UntarCompressionMethod.BZIP2, "tar.bz"){

        @Override
        public OutputStream wrapOutputStream(OutputStream out) throws IOException {
            return new BZip2CompressorOutputStream(out);
        }
    };

    private final TarArchiver.TarCompressionMethod tarCompressionMethod;
    private final TarUnArchiver.UntarCompressionMethod untarCompressionMethod;
    private final String fileSuffix;
    private static final int GZIP_BUFFER_SIZE = 65536;
    private static final int GZIP_COMPRESSION_LEVEL = 3;

    private ArchiveCompression(TarArchiver.TarCompressionMethod tarCompressionMethod, TarUnArchiver.UntarCompressionMethod untarCompressionMethod, String fileSuffix) {
        this.tarCompressionMethod = tarCompressionMethod;
        this.untarCompressionMethod = untarCompressionMethod;
        this.fileSuffix = fileSuffix;
    }

    public TarArchiver.TarCompressionMethod getTarCompressionMethod() {
        return this.tarCompressionMethod;
    }

    public TarUnArchiver.UntarCompressionMethod getUnTarCompressionMethod() {
        return this.untarCompressionMethod;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public OutputStream wrapOutputStream(OutputStream outputStream) throws IOException {
        return outputStream;
    }

    public static ArchiveCompression fromFileName(String filename) {
        if (filename.endsWith(".tar.gz") || filename.endsWith(".tgz")) {
            return gzip;
        }
        if (filename.endsWith(".tar.bz") || filename.endsWith(".tar.bzip2") || filename.endsWith(".tar.bz2")) {
            return bzip2;
        }
        return none;
    }

    private static class GZIPOutputStream
    extends java.util.zip.GZIPOutputStream {
        private GZIPOutputStream(OutputStream out) throws IOException {
            super(out, 65536);
            this.def.setLevel(3);
        }
    }
}

