/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.config;

import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluent;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.config.Route;
import io.dekorate.openshift.config.RouteBuilder;
import io.dekorate.openshift.config.RouteFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class OpenshiftConfigFluent<A extends OpenshiftConfigFluent<A>>
extends BaseConfigFluent<A> {
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private Integer replicas;
    private RouteBuilder route;
    private Boolean headless;

    public OpenshiftConfigFluent() {
    }

    public OpenshiftConfigFluent(OpenshiftConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OpenshiftConfig instance) {
        OpenshiftConfig openshiftConfig = instance = instance != null ? instance : new OpenshiftConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withPartOf(instance.getPartOf());
            this.withName(instance.getName());
            this.withVersion(instance.getVersion());
            this.withDeploymentKind(instance.getDeploymentKind());
            this.withLabels(instance.getLabels());
            this.withAnnotations(instance.getAnnotations());
            this.withEnvVars(instance.getEnvVars());
            this.withWorkingDir(instance.getWorkingDir());
            this.withCommand(instance.getCommand());
            this.withArguments(instance.getArguments());
            this.withServiceAccount(instance.getServiceAccount());
            this.withPorts(instance.getPorts());
            this.withServiceType(instance.getServiceType());
            this.withPvcVolumes(instance.getPvcVolumes());
            this.withSecretVolumes(instance.getSecretVolumes());
            this.withConfigMapVolumes(instance.getConfigMapVolumes());
            this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
            this.withGitRepoVolumes(instance.getGitRepoVolumes());
            this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
            this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
            this.withAzureFileVolumes(instance.getAzureFileVolumes());
            this.withMounts(instance.getMounts());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withDeploymentStrategy(instance.getDeploymentStrategy());
            this.withRollingUpdate(instance.getRollingUpdate());
            this.withHostAliases(instance.getHostAliases());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withStartupProbe(instance.getStartupProbe());
            this.withRequestResources(instance.getRequestResources());
            this.withLimitResources(instance.getLimitResources());
            this.withSidecars(instance.getSidecars());
            this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
            this.withJobs(instance.getJobs());
            this.withCronJobs(instance.getCronJobs());
            this.withInitContainers(instance.getInitContainers());
            this.withReplicas(instance.getReplicas());
            this.withRoute(instance.getRoute());
            this.withHeadless(instance.getHeadless());
        }
    }

    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
            this._visitables.remove((Object)"initContainers");
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public Container[] buildInitContainers() {
        int size = this.initContainers != null ? this.initContainers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.initContainers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").add(index, builder);
            this.initContainers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
            this.initContainers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInitContainers(Container ... items) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    public InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNested(-1, null);
    }

    public InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNested(-1, item);
    }

    public InitContainersNested<A> setNewInitContainerLike(int index, Container item) {
        return new InitContainersNested(index, item);
    }

    public InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    public InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Route buildRoute() {
        return this.route != null ? this.route.build() : null;
    }

    public A withRoute(Route route) {
        this._visitables.remove((Object)"route");
        if (route != null) {
            this.route = new RouteBuilder(route);
            this._visitables.get((Object)"route").add(this.route);
        } else {
            this.route = null;
            this._visitables.get((Object)"route").remove((Object)this.route);
        }
        return (A)((Object)this);
    }

    public boolean hasRoute() {
        return this.route != null;
    }

    public RouteNested<A> withNewRoute() {
        return new RouteNested(null);
    }

    public RouteNested<A> withNewRouteLike(Route item) {
        return new RouteNested(item);
    }

    public RouteNested<A> editRoute() {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(null));
    }

    public RouteNested<A> editOrNewRoute() {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(new RouteBuilder().build()));
    }

    public RouteNested<A> editOrNewRouteLike(Route item) {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(item));
    }

    public Boolean getHeadless() {
        return this.headless;
    }

    public A withHeadless(Boolean headless) {
        this.headless = headless;
        return (A)((Object)this);
    }

    public boolean hasHeadless() {
        return this.headless != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenshiftConfigFluent that = (OpenshiftConfigFluent)((Object)o);
        if (!Objects.equals(this.initContainers, that.initContainers)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals((Object)this.route, (Object)that.route)) {
            return false;
        }
        return Objects.equals(this.headless, that.headless);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.initContainers, this.replicas, this.route, this.headless, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.route != null) {
            sb.append("route:");
            sb.append((Object)((Object)this.route) + ",");
        }
        if (this.headless != null) {
            sb.append("headless:");
            sb.append(this.headless);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withHeadless() {
        return this.withHeadless(true);
    }

    public class RouteNested<N>
    extends RouteFluent<RouteNested<N>>
    implements Nested<N> {
        RouteBuilder builder;

        RouteNested(Route item) {
            this.builder = new RouteBuilder(this, item);
        }

        public N and() {
            return (N)OpenshiftConfigFluent.this.withRoute(this.builder.build());
        }

        public N endRoute() {
            return this.and();
        }
    }

    public class InitContainersNested<N>
    extends ContainerFluent<InitContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        InitContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        public N and() {
            return (N)OpenshiftConfigFluent.this.setToInitContainers(this.index, (Container)this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }
}

