/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.visitors.dereference;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.IReferenceNode;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.util.IReferenceResolver;
import io.apicurio.datamodels.core.util.ReferenceResolverChain;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.visitors.dereference.Aai20IReferenceManipulationStrategy;
import io.apicurio.datamodels.openapi.visitors.dereference.AbstractReferenceLocalizationStrategy;
import io.apicurio.datamodels.openapi.visitors.dereference.IReferenceManipulationStrategy;
import io.apicurio.datamodels.openapi.visitors.dereference.Oas20IReferenceManipulationStrategy;
import io.apicurio.datamodels.openapi.visitors.dereference.Oas30IReferenceManipulationStrategy;
import io.apicurio.datamodels.openapi.visitors.dereference.Reference;
import io.apicurio.datamodels.openapi.visitors.dereference.ReferenceCollectionVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Dereferencer {
    private final Document source;
    private final IReferenceResolver resolver;
    private final boolean strict;
    private final Set<String> unresolvable = new HashSet<String>();

    public Dereferencer(Document source) {
        this(source, ReferenceResolverChain.getInstance(), false);
    }

    public Dereferencer(Document source, IReferenceResolver resolver, boolean strict) {
        this.source = source;
        this.resolver = resolver;
        this.strict = strict;
    }

    public Document dereference() {
        Document clone = Library.cloneDocument(this.source);
        AbstractReferenceLocalizationStrategy strategy = null;
        switch (clone.getDocumentType()) {
            case asyncapi2: {
                strategy = new Aai20IReferenceManipulationStrategy();
                break;
            }
            case openapi2: {
                strategy = new Oas20IReferenceManipulationStrategy();
                break;
            }
            case openapi3: {
                strategy = new Oas30IReferenceManipulationStrategy();
                break;
            }
            default: {
                throw new RuntimeException("Unknown document type: " + (Object)((Object)clone.getDocumentType()));
            }
        }
        LinkedList<Context> processQueue = new LinkedList<Context>();
        processQueue.add(new Context(null, clone));
        HashMap<String, String> resolvedToLocalMap = new HashMap<String, String>();
        for (String ref : strategy.getExistingLocalComponents(clone).keySet()) {
            resolvedToLocalMap.put(ref, ref);
        }
        while (!processQueue.isEmpty()) {
            Context item = (Context)processQueue.remove();
            Map<String, Node> localComponents = strategy.getExistingLocalComponents(clone);
            ReferenceCollectionVisitor rcv = new ReferenceCollectionVisitor();
            VisitorUtil.visitTree(item.node, rcv, TraverserDirection.down);
            List<IReferenceNode> referencedNodes = rcv.getReferencedNodes();
            for (IReferenceNode node : referencedNodes) {
                if (item.parentRef == null && localComponents.containsKey(node.getReference())) continue;
                Reference originalRef = new Reference(node.getReference());
                if (item.parentRef != null && originalRef.isRelative()) {
                    originalRef = originalRef.withAbsoluteFrom(new Reference(item.parentRef));
                }
                if (resolvedToLocalMap.containsKey(originalRef.getRef())) {
                    node.setReference((String)resolvedToLocalMap.get(originalRef.getRef()));
                    continue;
                }
                Node resolved = this.resolver.resolveRef(originalRef.getRef(), (Node)((Object)node));
                if (resolved == null) {
                    this.unresolvable.add(node.getReference());
                    continue;
                }
                IReferenceManipulationStrategy.ReferenceAndNode localRef = null;
                String name = originalRef.getName();
                boolean nameReused = false;
                if (name.equals(strategy.getComponentName(clone, resolved))) {
                    nameReused = strategy.removeComponent(clone, name);
                }
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    if (i > 0) {
                        name = originalRef.getName() + i;
                    }
                    try {
                        localRef = strategy.attachAsComponent(clone, name, resolved);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        if (!nameReused) continue;
                        throw new IllegalStateException("Assertion error: Component with name '" + name + "' should be reused, but can't be attached.");
                    }
                }
                if (localRef == null) {
                    this.unresolvable.add(node.getReference());
                    continue;
                }
                if (!nameReused) {
                    node.setReference(localRef.getRef());
                }
                processQueue.add(new Context(originalRef.getRef(), localRef.getNode()));
                resolvedToLocalMap.put(originalRef.getRef(), localRef.getRef());
            }
        }
        if (this.unresolvable.size() != 0 && this.strict) {
            throw new RuntimeException("Could not resolve some references: " + this.unresolvable);
        }
        return clone;
    }

    public IReferenceResolver getResolver() {
        return this.resolver;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public Set<String> getUnresolvableReferences() {
        return new HashSet<String>(this.unresolvable);
    }

    private class Context {
        private String parentRef;
        private Node node;

        private Context(String parentRef, Node node) {
            this.parentRef = parentRef;
            this.node = node;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context context = (Context)o;
            if (this.parentRef != null ? !this.parentRef.equals(context.parentRef) : context.parentRef != null) {
                return false;
            }
            return this.node != null ? this.node.equals(context.node) : context.node == null;
        }

        public int hashCode() {
            int result = this.parentRef != null ? this.parentRef.hashCode() : 0;
            result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
            return result;
        }
    }
}

