/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.visitors;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.AuthorizationCodeOAuthFlow;
import io.apicurio.datamodels.core.models.common.ClientCredentialsOAuthFlow;
import io.apicurio.datamodels.core.models.common.Components;
import io.apicurio.datamodels.core.models.common.IExample;
import io.apicurio.datamodels.core.models.common.ImplicitOAuthFlow;
import io.apicurio.datamodels.core.models.common.ModernSecurityScheme;
import io.apicurio.datamodels.core.models.common.OAuthFlows;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.PasswordOAuthFlow;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.core.models.common.ServerVariable;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v3.models.Oas30Callback;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30CallbackPathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30Components;
import io.apicurio.datamodels.openapi.v3.models.Oas30Discriminator;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Encoding;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30ExampleDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30HeaderDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Link;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkParameterExpression;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkRequestBodyExpression;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkServer;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30PathItem;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBodyDefinition;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.visitors.IOas30Visitor;
import io.apicurio.datamodels.openapi.visitors.OasTraverser;

public class Oas30Traverser
extends OasTraverser
implements IOas30Visitor {
    public Oas30Traverser(IOas30Visitor visitor) {
        super(visitor);
    }

    @Override
    protected void traverseDocument(Document node) {
        Oas30Document doc = (Oas30Document)node;
        super.traverseDocument(doc);
        this.traverseCollection(doc.servers);
        this.traverseIfNotNull(doc.components);
    }

    @Override
    protected void traverseParameter(Parameter node) {
        super.traverseParameter(node);
        Oas30Parameter param = (Oas30Parameter)node;
        this.traverseCollection(param.getExamples());
        this.traverseCollection(param.getMediaTypes());
    }

    @Override
    protected void traverseResponse(OasResponse node) {
        super.traverseResponse(node);
        Oas30Response response = (Oas30Response)node;
        this.traverseCollection(response.getHeaders());
        this.traverseCollection(response.getMediaTypes());
        this.traverseCollection(response.getLinks());
    }

    @Override
    protected void traverseSchema(Schema node) {
        super.traverseSchema(node);
        Oas30Schema schema = (Oas30Schema)node;
        this.traverseCollection(schema.oneOf);
        this.traverseCollection(schema.anyOf);
        this.traverseIfNotNull(schema.not);
        this.traverseIfNotNull(schema.discriminator);
    }

    @Override
    protected void traverseOperation(Operation node) {
        super.traverseOperation(node);
        Oas30Operation op = (Oas30Operation)node;
        this.traverseIfNotNull(op.requestBody);
        this.traverseCollection(op.getCallbacks());
        this.traverseCollection(op.servers);
    }

    @Override
    protected void traverseHeader(OasHeader node) {
        super.traverseHeader(node);
        Oas30Header header = (Oas30Header)node;
        this.traverseIfNotNull(header.schema);
        this.traverseCollection(header.getExamples());
        this.traverseCollection(header.getMediaTypes());
    }

    @Override
    public void visitComponents(Components node) {
        Oas30Components components = (Oas30Components)node;
        node.accept(this.visitor);
        this.traverseCollection(components.getSchemaDefinitions());
        this.traverseCollection(components.getResponseDefinitions());
        this.traverseCollection(components.getParameterDefinitions());
        this.traverseCollection(components.getExampleDefinitions());
        this.traverseCollection(components.getRequestBodyDefinitions());
        this.traverseCollection(components.getHeaderDefinitions());
        this.traverseCollection(components.getSecuritySchemes());
        this.traverseCollection(components.getLinkDefinitions());
        this.traverseCollection(components.getCallbackDefinitions());
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    protected void traversePathItem(OasPathItem node) {
        super.traversePathItem(node);
        Oas30PathItem pathItem = (Oas30PathItem)node;
        this.traverseIfNotNull(pathItem.trace);
        this.traverseCollection(pathItem.servers);
    }

    @Override
    public void visitCallbackPathItem(Oas30CallbackPathItem node) {
        this.visitPathItem(node);
    }

    @Override
    public void visitCallback(Oas30Callback node) {
        node.accept(this.visitor);
        this.traverseIndexedNode(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitLinkServer(Oas30LinkServer node) {
        this.visitServer(node);
    }

    @Override
    public void visitCallbackDefinition(Oas30CallbackDefinition node) {
        this.visitCallback(node);
    }

    @Override
    public void visitLink(Oas30Link node) {
        node.accept(this.visitor);
        this.traverseCollection(node.getLinkParameterExpressions());
        this.traverseIfNotNull(node.requestBody);
        this.traverseIfNotNull(node.server);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitLinkRequestBodyExpression(Oas30LinkRequestBodyExpression node) {
        node.accept(this.visitor);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitLinkParameterExpression(Oas30LinkParameterExpression node) {
        node.accept(this.visitor);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitLinkDefinition(Oas30LinkDefinition node) {
        this.visitLink(node);
    }

    @Override
    public void visitAuthorizationCodeOAuthFlow(AuthorizationCodeOAuthFlow node) {
        this.traverseOAuthFlow(node);
    }

    @Override
    public void visitClientCredentialsOAuthFlow(ClientCredentialsOAuthFlow node) {
        this.traverseOAuthFlow(node);
    }

    @Override
    public void visitPasswordOAuthFlow(PasswordOAuthFlow node) {
        this.traverseOAuthFlow(node);
    }

    @Override
    public void visitImplicitOAuthFlow(ImplicitOAuthFlow node) {
        this.traverseOAuthFlow(node);
    }

    @Override
    public void visitOAuthFlows(OAuthFlows node) {
        this.traverseOAuthFlows(node);
    }

    @Override
    public void visitExample(IExample node) {
        Oas30Example example30 = (Oas30Example)node;
        node.accept(this.visitor);
        this.traverseExtensions(example30);
        this.traverseValidationProblems(example30);
    }

    @Override
    public void visitEncoding(Oas30Encoding node) {
        node.accept(this.visitor);
        this.traverseCollection(node.getHeaders());
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitMediaType(Oas30MediaType node) {
        node.accept(this.visitor);
        this.traverseIfNotNull(node.schema);
        this.traverseCollection(node.getExamples());
        this.traverseCollection(node.getEncodings());
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitHeaderDefinition(Oas30HeaderDefinition node) {
        this.visitHeader(node);
    }

    @Override
    public void visitRequestBody(Oas30RequestBody node) {
        node.accept(this.visitor);
        this.traverseCollection(node.getMediaTypes());
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitRequestBodyDefinition(Oas30RequestBodyDefinition node) {
        this.visitRequestBody(node);
    }

    @Override
    public void visitExampleDefinition(Oas30ExampleDefinition node) {
        this.visitExample(node);
    }

    @Override
    public void visitDiscriminator(Oas30Discriminator node) {
        node.accept(this.visitor);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitNotSchema(Oas30Schema.Oas30NotSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
        this.visitSchema(node);
    }

    @Override
    protected void traverseSecurityScheme(SecurityScheme node) {
        super.traverseSecurityScheme(node);
        ModernSecurityScheme scheme = (ModernSecurityScheme)node;
        this.traverseIfNotNull(scheme.flows);
    }

    @Override
    public void visitServer(Server node) {
        node.accept(this.visitor);
        this.traverseCollection(node.getServerVariables());
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitServerVariable(ServerVariable node) {
        node.accept(this.visitor);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }
}

