/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.models;

import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.IReferenceNode;
import io.apicurio.datamodels.core.models.common.INamed;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkParameterExpression;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkRequestBodyExpression;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkServer;
import io.apicurio.datamodels.openapi.v3.visitors.IOas30Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Oas30Link
extends ExtensibleNode
implements INamed,
IReferenceNode {
    private String _name;
    public String $ref;
    public String operationRef;
    public String operationId;
    public Map<String, Oas30LinkParameterExpression> parameters = new LinkedHashMap<String, Oas30LinkParameterExpression>();
    public Oas30LinkRequestBodyExpression requestBody;
    public String description;
    public Oas30LinkServer server;

    public Oas30Link(String name) {
        this._name = name;
    }

    @Override
    public void accept(IVisitor visitor) {
        IOas30Visitor viz = (IOas30Visitor)visitor;
        viz.visitLink(this);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void rename(String newName) {
        this._name = newName;
    }

    @Override
    public String getReference() {
        return this.$ref;
    }

    @Override
    public void setReference(String reference) {
        this.$ref = reference;
    }

    public Oas30LinkParameterExpression createLinkParameterExpression(String name, String value) {
        Oas30LinkParameterExpression rval = new Oas30LinkParameterExpression(name, value);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public void addLinkParameterExpression(String name, Oas30LinkParameterExpression expression) {
        this.parameters.put(name, expression);
    }

    public Oas30LinkParameterExpression addLinkParameter(String name, String expression) {
        Oas30LinkParameterExpression model = this.createLinkParameterExpression(name, expression);
        this.addLinkParameterExpression(name, model);
        return model;
    }

    public Oas30LinkParameterExpression getLinkParameterExpression(String name) {
        return this.parameters.get(name);
    }

    public Oas30LinkParameterExpression removeLinkParameterExpression(String name) {
        return this.parameters.remove(name);
    }

    public List<Oas30LinkParameterExpression> getLinkParameterExpressions() {
        ArrayList<Oas30LinkParameterExpression> rval = new ArrayList<Oas30LinkParameterExpression>();
        rval.addAll(this.parameters.values());
        return rval;
    }

    public Oas30LinkRequestBodyExpression createLinkRequestBodyExpression(String value) {
        Oas30LinkRequestBodyExpression rval = new Oas30LinkRequestBodyExpression(value);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public Oas30LinkServer createServer() {
        Oas30LinkServer rval = new Oas30LinkServer();
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }
}

