/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.io;

import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.io.DataModelReader;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasResponses;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.models.OasSecurityRequirement;
import io.apicurio.datamodels.openapi.models.OasXML;
import java.util.ArrayList;
import java.util.List;

public abstract class OasDataModelReader
extends DataModelReader {
    @Override
    public void readDocument(Object json, Document node) {
        OasDocument doc = (OasDocument)node;
        Object paths = JsonCompat.consumeProperty(json, "paths");
        List<Object> security = JsonCompat.consumePropertyArray(json, "security");
        if (paths != null) {
            doc.paths = doc.createPaths();
            this.readPaths(paths, doc.paths);
        }
        if (security != null) {
            security.forEach(sec -> {
                OasSecurityRequirement secModel = doc.createSecurityRequirement();
                this.readSecurityRequirement(sec, secModel);
                doc.addSecurityRequirement(secModel);
            });
        }
        super.readDocument(json, doc);
    }

    public void readPaths(Object json, OasPaths node) {
        List<String> pathNames = JsonCompat.keys(json);
        for (String pathName : pathNames) {
            if (pathName.indexOf("x-") == 0) continue;
            Object pathItem = JsonCompat.consumeProperty(json, pathName);
            OasPathItem pathItemModel = node.createPathItem(pathName);
            this.readPathItem(pathItem, pathItemModel);
            node.addPathItem(pathName, pathItemModel);
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readPathItem(Object json, OasPathItem node) {
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        Object get = JsonCompat.consumeProperty(json, "get");
        Object put = JsonCompat.consumeProperty(json, "put");
        Object post = JsonCompat.consumeProperty(json, "post");
        Object delete = JsonCompat.consumeProperty(json, "delete");
        Object options = JsonCompat.consumeProperty(json, "options");
        Object head = JsonCompat.consumeProperty(json, "head");
        Object patch = JsonCompat.consumeProperty(json, "patch");
        List<Object> parameters = JsonCompat.consumePropertyArray(json, "parameters");
        node.$ref = $ref;
        if (get != null) {
            node.get = node.createOperation("get");
            this.readOperation(get, node.get);
        }
        if (put != null) {
            node.put = node.createOperation("put");
            this.readOperation(put, node.put);
        }
        if (post != null) {
            node.post = node.createOperation("post");
            this.readOperation(post, node.post);
        }
        if (delete != null) {
            node.delete = node.createOperation("delete");
            this.readOperation(delete, node.delete);
        }
        if (options != null) {
            node.options = node.createOperation("options");
            this.readOperation(options, node.options);
        }
        if (head != null) {
            node.head = node.createOperation("head");
            this.readOperation(head, node.head);
        }
        if (patch != null) {
            node.patch = node.createOperation("patch");
            this.readOperation(patch, node.patch);
        }
        if (parameters != null) {
            parameters.forEach(parameter -> {
                OasParameter parameterModel = node.createParameter();
                this.readParameter(parameter, parameterModel);
                node.addParameter(parameterModel);
            });
        }
        this.readExtensions(json, node);
    }

    @Override
    public void readOperation(Object json, Operation node) {
        OasOperation operation = (OasOperation)node;
        List<String> tags = JsonCompat.consumePropertyStringArray(json, "tags");
        List<Object> parameters = JsonCompat.consumePropertyArray(json, "parameters");
        Object responses = JsonCompat.consumeProperty(json, "responses");
        Boolean deprecated = JsonCompat.consumePropertyBoolean(json, "deprecated");
        List<Object> security = JsonCompat.consumePropertyArray(json, "security");
        operation.tags = tags;
        operation.deprecated = deprecated;
        if (parameters != null) {
            parameters.forEach(parameter -> {
                OasParameter parameterModel = operation.createParameter();
                this.readParameter(parameter, parameterModel);
                operation.addParameter(parameterModel);
            });
        }
        if (responses != null) {
            operation.responses = operation.createResponses();
            this.readResponses(responses, operation.responses);
        }
        if (security != null) {
            security.forEach(requirement -> {
                OasSecurityRequirement requirementModel = operation.createSecurityRequirement();
                this.readSecurityRequirement(requirement, requirementModel);
                operation.addSecurityRequirement(requirementModel);
            });
        }
        super.readOperation(json, node);
    }

    public void readResponses(Object json, OasResponses node) {
        Object default_ = JsonCompat.consumeProperty(json, "default");
        if (default_ != null) {
            node.default_ = node.createDefaultResponse();
            this.readResponse(default_, node.default_);
        }
        List<String> responseCodes = JsonCompat.keys(json);
        responseCodes.forEach(code -> {
            if (code.indexOf("x-") != 0) {
                Object response = JsonCompat.consumeProperty(json, code);
                OasResponse responseModel = node.createResponse((String)code);
                this.readResponse(response, responseModel);
                node.addResponse((String)code, responseModel);
            }
        });
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    @Override
    public void readSchema(Object json, Schema node) {
        ArrayList<OasSchema> schemaModels;
        OasSchema schema = (OasSchema)node;
        String format = JsonCompat.consumePropertyString(json, "format");
        String title = JsonCompat.consumePropertyString(json, "title");
        String description = JsonCompat.consumePropertyString(json, "description");
        Object default_ = JsonCompat.consumePropertyObject(json, "default");
        Number multipleOf = JsonCompat.consumePropertyNumber(json, "multipleOf");
        Number maximum = JsonCompat.consumePropertyNumber(json, "maximum");
        Boolean exclusiveMaximum = JsonCompat.consumePropertyBoolean(json, "exclusiveMaximum");
        Number minimum = JsonCompat.consumePropertyNumber(json, "minimum");
        Boolean exclusiveMinimum = JsonCompat.consumePropertyBoolean(json, "exclusiveMinimum");
        Number maxLength = JsonCompat.consumePropertyNumber(json, "maxLength");
        Number minLength = JsonCompat.consumePropertyNumber(json, "minLength");
        String pattern = JsonCompat.consumePropertyString(json, "pattern");
        Number maxItems = JsonCompat.consumePropertyNumber(json, "maxItems");
        Number minItems = JsonCompat.consumePropertyNumber(json, "minItems");
        Boolean uniqueItems = JsonCompat.consumePropertyBoolean(json, "uniqueItems");
        Number maxProperties = JsonCompat.consumePropertyNumber(json, "maxProperties");
        Number minProperties = JsonCompat.consumePropertyNumber(json, "minProperties");
        List<String> required = JsonCompat.consumePropertyStringArray(json, "required");
        List<String> enum_ = JsonCompat.consumePropertyStringArray(json, "enum");
        String type = JsonCompat.consumePropertyString(json, "type");
        Object items = JsonCompat.consumeProperty(json, "items");
        List<Object> allOf = JsonCompat.consumePropertyArray(json, "allOf");
        Object properties = JsonCompat.consumeProperty(json, "properties");
        Object additionalProperties = JsonCompat.consumeProperty(json, "additionalProperties");
        Boolean readOnly = JsonCompat.consumePropertyBoolean(json, "readOnly");
        Object xml = JsonCompat.consumeProperty(json, "xml");
        Object externalDocs = JsonCompat.consumeProperty(json, "externalDocs");
        Object example = JsonCompat.consumePropertyObject(json, "example");
        schema.format = format;
        schema.title = title;
        schema.description = description;
        schema.default_ = default_;
        schema.multipleOf = multipleOf;
        schema.maximum = maximum;
        schema.exclusiveMaximum = exclusiveMaximum;
        schema.minimum = minimum;
        schema.exclusiveMinimum = exclusiveMinimum;
        schema.maxLength = maxLength;
        schema.minLength = minLength;
        schema.pattern = pattern;
        schema.maxItems = maxItems;
        schema.minItems = minItems;
        schema.uniqueItems = uniqueItems;
        schema.maxProperties = maxProperties;
        schema.minProperties = minProperties;
        schema.required = required;
        schema.enum_ = enum_;
        schema.type = type;
        schema.readOnly = readOnly;
        schema.example = example;
        if (items != null) {
            if (JsonCompat.isArray(items)) {
                schemaModels = new ArrayList();
                List<Object> itemList = JsonCompat.toList(items);
                for (Object item : itemList) {
                    OasSchema itemsSchemaModel = schema.createItemsSchema();
                    this.readSchema(item, itemsSchemaModel);
                    schemaModels.add(itemsSchemaModel);
                }
                schema.items = schemaModels;
            } else {
                schema.items = schema.createItemsSchema();
                this.readSchema(items, (OasSchema)schema.items);
            }
        }
        if (allOf != null) {
            schemaModels = new ArrayList<OasSchema>();
            for (Object allOfSchema : allOf) {
                OasSchema allOfSchemaModel = schema.createAllOfSchema();
                this.readSchema(allOfSchema, allOfSchemaModel);
                schemaModels.add(allOfSchemaModel);
            }
            schema.allOf = schemaModels;
        }
        if (properties != null) {
            List<String> propertyNames = JsonCompat.keys(properties);
            for (String propertyName : propertyNames) {
                Object propertySchema = JsonCompat.consumeProperty(properties, propertyName);
                Schema propertySchemaModel = schema.createPropertySchema(propertyName);
                this.readSchema(propertySchema, propertySchemaModel);
                schema.addProperty(propertyName, propertySchemaModel);
            }
        }
        if (additionalProperties != null) {
            if (JsonCompat.isBoolean(additionalProperties)) {
                schema.additionalProperties = JsonCompat.toBoolean(additionalProperties);
            } else {
                OasSchema additionalPropertiesModel = schema.createAdditionalPropertiesSchema();
                this.readSchema(additionalProperties, additionalPropertiesModel);
                schema.additionalProperties = additionalPropertiesModel;
            }
        }
        if (xml != null) {
            schema.xml = schema.createXML();
            this.readXML(xml, schema.xml);
        }
        if (externalDocs != null) {
            schema.externalDocs = schema.createExternalDocumentation();
            this.readExternalDocumentation(externalDocs, schema.externalDocs);
        }
        super.readSchema(json, schema);
    }

    public void readXML(Object json, OasXML node) {
        String name = JsonCompat.consumePropertyString(json, "name");
        String namespace = JsonCompat.consumePropertyString(json, "namespace");
        String prefix = JsonCompat.consumePropertyString(json, "prefix");
        Boolean attribute = JsonCompat.consumePropertyBoolean(json, "attribute");
        Boolean wrapped = JsonCompat.consumePropertyBoolean(json, "wrapped");
        node.name = name;
        node.namespace = namespace;
        node.prefix = prefix;
        node.attribute = attribute;
        node.wrapped = wrapped;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    @Override
    public void readParameter(Object json, Parameter node) {
        OasParameter param = (OasParameter)node;
        String in = JsonCompat.consumePropertyString(json, "in");
        Boolean required = JsonCompat.consumePropertyBoolean(json, "required");
        Boolean allowEmptyValue = JsonCompat.consumePropertyBoolean(json, "allowEmptyValue");
        param.in = in;
        param.required = required;
        param.allowEmptyValue = allowEmptyValue;
        super.readParameter(json, node);
    }

    public void readResponse(Object json, OasResponse node) {
        String $ref = JsonCompat.consumePropertyString(json, "$ref");
        String description = JsonCompat.consumePropertyString(json, "description");
        node.$ref = $ref;
        node.description = description;
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    public void readHeader(Object json, OasHeader node) {
        node.description = JsonCompat.consumePropertyString(json, "description");
    }
}

