/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.mutex;

import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30HeaderDefinition;

public class OasHeaderSchemaContentMutualExclusivityRule
extends ValidationRule {
    public OasHeaderSchemaContentMutualExclusivityRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean hasContent(Oas30Header contentParent) {
        return contentParent.getMediaTypes().size() > 0;
    }

    @Override
    public void visitHeader(OasHeader node) {
        Oas30Header header = (Oas30Header)node;
        this.reportIf(this.hasValue(header.schema) && this.hasContent(header), node, "schema", this.map(new String[0]));
    }

    @Override
    public void visitHeaderDefinition(Oas30HeaderDefinition node) {
        this.visitHeader(node);
    }
}

