/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.mutex;

import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.models.IOasParameterParent;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.util.List;

public class OasBodyAndFormDataMutualExclusivityRule
extends ValidationRule {
    public OasBodyAndFormDataMutualExclusivityRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private void visitParameterParent(IOasParameterParent paramParent) {
        List<OasParameter> parameters = paramParent.getParameters();
        if (this.hasValue(parameters)) {
            boolean hasBodyParam = false;
            boolean hasFormDataParam = false;
            for (OasParameter param : parameters) {
                if (this.equals(param.in, "body")) {
                    hasBodyParam = true;
                }
                if (!this.equals(param.in, "formData")) continue;
                hasFormDataParam = true;
            }
            this.reportIf(hasBodyParam && hasFormDataParam, (Node)((Object)paramParent), "in", this.map(new String[0]));
        }
    }

    @Override
    public void visitOperation(Operation node) {
        this.visitParameterParent((OasOperation)node);
    }

    @Override
    public void visitPathItem(OasPathItem node) {
        this.visitParameterParent(node);
    }
}

