/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.reference;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;

public class OasInvalidSecurityRequirementNameRule
extends ValidationRule {
    public OasInvalidSecurityRequirementNameRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean isValidSecurityRequirementName(String securityReqName, Document doc) {
        DocumentType dt = doc.getDocumentType();
        if (dt == DocumentType.openapi2) {
            Oas20Document doc20 = (Oas20Document)doc;
            return this.hasValue(doc20.securityDefinitions) && this.isDefined(doc20.securityDefinitions.getSecurityScheme(securityReqName));
        }
        if (dt == DocumentType.openapi3) {
            Oas30Document doc30 = (Oas30Document)doc;
            return this.hasValue(doc30.components) && this.isDefined(doc30.components.getSecurityScheme(securityReqName));
        }
        if (dt == DocumentType.asyncapi2) {
            // empty if block
        }
        return false;
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        node.getSecurityRequirementNames().forEach(name -> this.reportIfInvalid(this.isValidSecurityRequirementName((String)name, node.ownerDocument()), node, null, this.map("name", (String)name)));
    }
}

