/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.reference;

import io.apicurio.datamodels.core.util.ReferenceUtil;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.models.Oas30HeaderDefinition;

public class OasInvalidHeaderReferenceRule
extends ValidationRule {
    public OasInvalidHeaderReferenceRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitHeader(OasHeader node) {
        Oas30Header header = (Oas30Header)node;
        if (this.hasValue(header.$ref)) {
            this.reportIfInvalid(ReferenceUtil.canResolveRef(header.$ref, header), header, "$ref", this.map(new String[0]));
        }
    }

    @Override
    public void visitHeaderDefinition(Oas30HeaderDefinition node) {
        this.visitHeader(node);
    }
}

