/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.name;

import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.name.OasInvalidPropertyNameRule;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Encoding;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;

public class OasUnmatchedEncodingPropertyRule
extends OasInvalidPropertyNameRule {
    public OasUnmatchedEncodingPropertyRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    private boolean isValidSchemaProperty(OasSchema schema, String propertyName) {
        if (this.isNullOrUndefined(schema)) {
            return false;
        }
        return !this.isNullOrUndefined(schema.getProperty(propertyName));
    }

    @Override
    public void visitEncoding(Oas30Encoding node) {
        String name = node.getName();
        Oas30Schema schema = ((Oas30MediaType)node.parent()).schema;
        this.reportIfInvalid(this.isValidSchemaProperty(schema, name), node, name, this.map("name", name));
    }
}

