/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.factories;

import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;

public class DocumentFactory {
    public static final Document create(DocumentType type) {
        switch (type) {
            case asyncapi2: {
                Aai20Document doc = new Aai20Document();
                doc.asyncapi = "2.0.0";
                return doc;
            }
            case openapi2: {
                Oas20Document doc = new Oas20Document();
                return doc;
            }
            case openapi3: {
                Oas30Document doc = new Oas30Document();
                doc.openapi = "3.0.2";
                return doc;
            }
        }
        throw new RuntimeException("Failed to create a Document for type: " + (Object)((Object)type));
    }
}

