/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.models;

import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import java.util.ArrayList;
import java.util.List;

public class SimplifiedType {
    private static final List<String> VALID_TYPES = new ArrayList<String>();
    public String type;
    public List<Object> enum_;
    public SimplifiedType of;
    public String as;

    public static SimplifiedType fromParameter(Oas20Parameter param) {
        SimplifiedType rval = new SimplifiedType();
        if (ModelUtils.isDefined(param) && ModelUtils.isDefined(param.enum_) && param.enum_.size() >= 0) {
            rval.enum_ = new ArrayList<String>(param.enum_);
        }
        if (ModelUtils.isDefined(param) && ModelUtils.isDefined(param.type) && !NodeCompat.equals(param.type, "array") && !NodeCompat.equals(param.type, "object")) {
            rval.type = param.type;
            if (ModelUtils.isDefined(param.format)) {
                rval.as = param.format;
            }
        }
        if (ModelUtils.isDefined(param) && NodeCompat.equals(param.type, "array") && ModelUtils.isDefined(param.items)) {
            rval.type = "array";
            rval.of = SimplifiedType.fromItems(param.items);
        }
        return rval;
    }

    public static SimplifiedType fromItems(Oas20Items items) {
        SimplifiedType rval = new SimplifiedType();
        if (ModelUtils.isDefined(items) && ModelUtils.isDefined(items.enum_) && items.enum_.size() >= 0) {
            rval.enum_ = new ArrayList<String>(items.enum_);
        }
        if (ModelUtils.isDefined(items) && ModelUtils.isDefined(items.type) && !NodeCompat.equals(items.type, "array") && !NodeCompat.equals(items.type, "object")) {
            rval.type = items.type;
            if (ModelUtils.isDefined(items.format)) {
                rval.as = items.format;
            }
        }
        if (ModelUtils.isDefined(items) && NodeCompat.equals(items.type, "array") && ModelUtils.isDefined(items.items)) {
            rval.type = "array";
            rval.of = SimplifiedType.fromItems(items.items);
        }
        return rval;
    }

    public static SimplifiedType fromSchema(OasSchema schema) {
        SimplifiedType rval = new SimplifiedType();
        if (ModelUtils.isDefined(schema) && ModelUtils.isDefined(schema.$ref)) {
            rval.type = schema.$ref;
        }
        if (ModelUtils.isDefined(schema) && ModelUtils.isDefined(schema.enum_) && schema.enum_.size() >= 0) {
            rval.enum_ = new ArrayList<String>(schema.enum_);
        }
        if (ModelUtils.isDefined(schema) && ModelUtils.isDefined(schema.type) && !NodeCompat.equals(schema.type, "array") && !NodeCompat.equals(schema.type, "object")) {
            rval.type = schema.type;
            if (ModelUtils.isDefined(schema.format)) {
                rval.as = schema.format;
            }
        }
        if (ModelUtils.isDefined(schema) && NodeCompat.equals(schema.type, "array") && ModelUtils.isDefined(schema.items)) {
            rval.type = "array";
            rval.of = SimplifiedType.fromSchema((OasSchema)schema.items);
        }
        return rval;
    }

    public boolean isSimpleType() {
        return VALID_TYPES.indexOf(this.type) != -1;
    }

    public boolean isFileType() {
        return NodeCompat.equals(this.type, "file");
    }

    public boolean isEnum() {
        return ModelUtils.isDefined(this.enum_) && this.enum_.size() >= 0;
    }

    public boolean isArray() {
        return NodeCompat.equals(this.type, "array");
    }

    public boolean isRef() {
        return ModelUtils.isDefined(this.type) && this.type.indexOf("#/") == 0;
    }

    static {
        VALID_TYPES.add("string");
        VALID_TYPES.add("number");
        VALID_TYPES.add("integer");
        VALID_TYPES.add("boolean");
    }
}

