/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.models;

import io.apicurio.datamodels.cmd.models.SimplifiedType;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;

public class SimplifiedParameterType
extends SimplifiedType {
    public Boolean required;

    public static SimplifiedParameterType fromParameter(Parameter param) {
        SimplifiedType st;
        SimplifiedParameterType rval = new SimplifiedParameterType();
        if (param.ownerDocument().getDocumentType() == DocumentType.openapi2) {
            Oas20Parameter param20 = (Oas20Parameter)param;
            st = NodeCompat.equals(param20.in, "body") ? SimplifiedType.fromSchema((OasSchema)param20.schema) : SimplifiedType.fromParameter((Oas20Parameter)param);
            rval.required = param20.required;
        } else {
            Oas30Parameter param30 = (Oas30Parameter)param;
            st = SimplifiedType.fromSchema((OasSchema)param30.schema);
            rval.required = param30.required;
        }
        rval.type = st.type;
        rval.enum_ = st.enum_;
        rval.of = st.of;
        rval.as = st.as;
        return rval;
    }
}

