/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.OasOperation;

public class RenameTagDefinitionCommand
extends AbstractCommand {
    public String _oldTag;
    public String _newTag;

    RenameTagDefinitionCommand() {
    }

    RenameTagDefinitionCommand(String oldTag, String newTag) {
        this._oldTag = oldTag;
        this._newTag = newTag;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameTagDefinitionCommand] Executing.", new Object[0]);
        this._doTagRename(document, this._oldTag, this._newTag);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameTagDefinitionCommand] Reverting.", new Object[0]);
        this._doTagRename(document, this._newTag, this._oldTag);
    }

    private void _doTagRename(Document document, String from, String to) {
        Tag existingTag = this._findTag(document, to);
        if (ModelUtils.isDefined(existingTag)) {
            return;
        }
        Tag tagToRename = this._findTag(document, from);
        if (ModelUtils.isDefined(tagToRename)) {
            tagToRename.name = to;
            TagRenameVisitor tagRenamer = new TagRenameVisitor(from, to);
            VisitorUtil.visitTree(document, tagRenamer, TraverserDirection.down);
        }
    }

    private Tag _findTag(Document document, String tag) {
        if (ModelUtils.isDefined(document.tags)) {
            for (Tag tagDef : document.tags) {
                if (!NodeCompat.equals(tagDef.name, tag)) continue;
                return tagDef;
            }
        }
        return null;
    }

    private static class TagRenameVisitor
    extends CombinedVisitorAdapter {
        private String from;
        private String to;

        public TagRenameVisitor(String from, String to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public void visitOperation(Operation node) {
            int idx;
            OasOperation op = (OasOperation)node;
            int n = idx = ModelUtils.isDefined(op.tags) ? op.tags.indexOf(this.from) : -1;
            if (idx != -1) {
                op.tags.set(idx, this.to);
            }
        }
    }
}

