/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.asyncapi.models.AaiDocument;
import io.apicurio.datamodels.asyncapi.models.AaiMessageTrait;
import io.apicurio.datamodels.asyncapi.models.AaiMessageTraitDefinition;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20Document;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import java.util.ArrayList;
import java.util.List;

public class RenameMessageTraitDefinitionCommand
extends AbstractCommand {
    public String _oldName;
    public String _newName;
    public List<NodePath> _references;

    public RenameMessageTraitDefinitionCommand() {
    }

    public RenameMessageTraitDefinitionCommand(String oldName, String newName) {
        this._oldName = oldName;
        this._newName = newName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameMessageTraitDefinitionCommand] Executing.", new Object[0]);
        this._references = new ArrayList<NodePath>();
        AaiDocument doc = (AaiDocument)document;
        if (this.renameMessageTraitDefinition(doc, this._oldName, this._newName)) {
            String oldRef = this.nameToReference(this._oldName);
            String newRef = this.nameToReference(this._newName);
            MessageTraitRefFinder finder = new MessageTraitRefFinder(oldRef);
            List<AaiMessageTrait> traits = finder.findIn(document);
            for (AaiMessageTrait trait : traits) {
                this._references.add(Library.createNodePath(trait));
                trait.$ref = newRef;
            }
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameMessageTraitDefinitionCommand] Reverting.", new Object[0]);
        if (this.renameMessageTraitDefinition((AaiDocument)document, this._newName, this._oldName)) {
            String oldRef = this.nameToReference(this._oldName);
            if (ModelUtils.isDefined(this._references)) {
                this._references.forEach(ref -> {
                    AaiMessageTrait msgTrait = (AaiMessageTrait)ref.resolve(document);
                    msgTrait.$ref = oldRef;
                });
            }
        }
    }

    protected String nameToReference(String name) {
        return "#/components/messageTraits/" + name;
    }

    protected boolean renameMessageTraitDefinition(AaiDocument document, String fromName, String toName) {
        Aai20Document doc20 = (Aai20Document)document;
        if (this.isNullOrUndefined(doc20.components) || this.isNullOrUndefined(doc20.components.messageTraits)) {
            return false;
        }
        if (ModelUtils.isDefined(doc20.components.getMessageTraitDefinition(toName))) {
            return false;
        }
        AaiMessageTraitDefinition traitDef = doc20.components.removeMessageTraitDefinition(fromName);
        traitDef.rename(toName);
        doc20.components.addMessageTraitDefinition(toName, traitDef);
        return true;
    }

    private static class MessageTraitRefFinder
    extends CombinedVisitorAdapter {
        private final String reference;
        private final List<AaiMessageTrait> traits = new ArrayList<AaiMessageTrait>();

        public MessageTraitRefFinder(String ref) {
            this.reference = ref;
        }

        public List<AaiMessageTrait> findIn(Document document) {
            VisitorUtil.visitTree(document, this, TraverserDirection.down);
            return this.traits;
        }

        @Override
        public void visitMessageTrait(AaiMessageTrait node) {
            if (this.accept(node)) {
                this.traits.add(node);
            }
        }

        protected boolean accept(AaiMessageTrait trait) {
            return ModelUtils.isDefined(trait.$ref) && NodeCompat.equals(trait.$ref, this.reference);
        }
    }
}

