/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasOperation;

public abstract class NewRequestBodyCommand
extends AbstractCommand {
    public NodePath _operationPath;
    public boolean _created;

    NewRequestBodyCommand() {
    }

    NewRequestBodyCommand(OasOperation operation) {
        this._operationPath = Library.createNodePath(operation);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewRequestBodyCommand] Executing.", new Object[0]);
        this._created = false;
        OasOperation operation = (OasOperation)this._operationPath.resolve(document);
        if (this.isNullOrUndefined(operation)) {
            return;
        }
        if (this.hasRequestBody(operation)) {
            return;
        }
        this.doCreateRequestBody(operation);
        this._created = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewRequestBodyCommand] Reverting.", new Object[0]);
        if (!this._created) {
            return;
        }
        OasOperation operation = (OasOperation)this._operationPath.resolve(document);
        if (this.isNullOrUndefined(operation)) {
            return;
        }
        this.doRemoveRequestBody(operation);
    }

    protected abstract boolean hasRequestBody(OasOperation var1);

    protected abstract void doCreateRequestBody(OasOperation var1);

    protected abstract void doRemoveRequestBody(OasOperation var1);
}

