/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v3.models.IOas30MediaTypeParent;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;

public class NewMediaTypeCommand
extends AbstractCommand {
    public NodePath _nodePath;
    public String _newMediaType;
    public boolean _created;

    NewMediaTypeCommand() {
    }

    NewMediaTypeCommand(IOas30MediaTypeParent parent, String newMediaType) {
        this._nodePath = Library.createNodePath((Node)((Object)parent));
        this._newMediaType = newMediaType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewMediaTypeCommand] Executing.", new Object[0]);
        this._created = false;
        IOas30MediaTypeParent node = (IOas30MediaTypeParent)((Object)this._nodePath.resolve(document));
        if (this.isNullOrUndefined(node)) {
            return;
        }
        Oas30MediaType mediaType = node.getMediaType(this._newMediaType);
        if (ModelUtils.isDefined(mediaType)) {
            return;
        }
        node.addMediaType(this._newMediaType, node.createMediaType(this._newMediaType));
        this._created = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewMediaTypeCommand] Reverting.", new Object[0]);
        if (!this._created) {
            LoggerCompat.info("[NewMediaTypeCommand] media type already existed, nothing done so no rollback necessary.", new Object[0]);
            return;
        }
        IOas30MediaTypeParent node = (IOas30MediaTypeParent)((Object)this._nodePath.resolve(document));
        if (this.isNullOrUndefined(node)) {
            return;
        }
        node.removeMediaType(this._newMediaType);
    }
}

