/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;

public class DeletePathCommand
extends AbstractCommand {
    public String _path;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldPath;

    DeletePathCommand() {
    }

    DeletePathCommand(String path) {
        this._path = path;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeletePathCommand] Executing for path: %s", this._path);
        OasDocument odoc = (OasDocument)document;
        this._oldPath = null;
        OasPaths paths = odoc.paths;
        if (this.isNullOrUndefined(paths)) {
            return;
        }
        this._oldPath = Library.writeNode(paths.removePathItem(this._path));
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeletePathCommand] Reverting.", new Object[0]);
        OasDocument odoc = (OasDocument)document;
        OasPaths paths = odoc.paths;
        if (this.isNullOrUndefined(paths) || this.isNullOrUndefined(this._oldPath)) {
            return;
        }
        OasPathItem pathItem = paths.createPathItem(this._path);
        Library.readNode(this._oldPath, pathItem);
        paths.addPathItem(this._path, pathItem);
    }
}

