/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.openapi.models.OasDocument;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllTagsCommand
extends AbstractCommand {
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldTags;

    DeleteAllTagsCommand() {
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllTagsCommand] Executing.", new Object[0]);
        this._oldTags = new ArrayList<Object>();
        if (!this.isNullOrUndefined(document.tags)) {
            document.tags.forEach(tag -> this._oldTags.add(Library.writeNode(tag)));
        }
        OasDocument odoc = (OasDocument)document;
        odoc.tags = new ArrayList();
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllTagsCommand] Reverting.", new Object[0]);
        if (this._oldTags.size() == 0) {
            return;
        }
        OasDocument odoc = (OasDocument)document;
        if (this.isNullOrUndefined(document.tags)) {
            odoc.tags = new ArrayList();
        }
        this._oldTags.forEach(oldTag -> {
            Tag tag = document.createTag();
            Library.readNode(oldTag, tag);
            document.tags.add(tag);
        });
    }
}

