/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;

public class AddParameterExampleCommand_30
extends AbstractCommand {
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _newExampleValue;
    public String _newExampleName;
    public String _newExampleSummary;
    public String _newExampleDescription;
    public boolean _exampleAdded;

    AddParameterExampleCommand_30() {
    }

    AddParameterExampleCommand_30(Oas30Parameter parent, Object example, String exampleName) {
        this._parentPath = Library.createNodePath(parent);
        this._newExampleValue = example;
        this._newExampleName = exampleName;
    }

    AddParameterExampleCommand_30(Oas30Parameter parent, Object example, String exampleName, String exampleSummary, String exampleDescription) {
        this._parentPath = Library.createNodePath(parent);
        this._newExampleValue = example;
        this._newExampleName = exampleName;
        this._newExampleSummary = exampleSummary;
        this._newExampleDescription = exampleDescription;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[AddParameterExampleCommand_30] Executing.", new Object[0]);
        this._exampleAdded = false;
        Oas30Parameter parameter = (Oas30Parameter)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parameter)) {
            return;
        }
        if (!this.isNullOrUndefined(parameter.getExample(this._newExampleName))) {
            return;
        }
        Oas30Example example = parameter.createExample(this._newExampleName);
        example.summary = this._newExampleSummary;
        example.description = this._newExampleDescription;
        example.value = this._newExampleValue;
        parameter.addExample(example);
        this._exampleAdded = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[AddParameterExampleCommand_30] Reverting.", new Object[0]);
        if (!this._exampleAdded) {
            return;
        }
        Oas30Parameter parameter = (Oas30Parameter)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parameter) || this.isNullOrUndefined(parameter.examples)) {
            return;
        }
        parameter.removeExample(this._newExampleName);
    }
}

