/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels._build;

import java.io.File;
import java.io.FileWriter;
import java.util.Set;
import java.util.TreeSet;

public class GenerateCoreTs {
    private static String rootDir;

    public static void main(String[] args) throws Exception {
        File srcDir = null;
        if (args.length < 1) {
            throw new RuntimeException("Missing argument: srcDir");
        }
        srcDir = new File(args[0]);
        if (!srcDir.isDirectory()) {
            throw new RuntimeException("Invalid argument: srcDir must be a directory");
        }
        rootDir = srcDir.getAbsolutePath();
        Set<String> tsPaths = GenerateCoreTs.findTsPaths(srcDir);
        File outputFile = new File(srcDir, "core.ts");
        if (outputFile.exists() && outputFile.isFile()) {
            outputFile.delete();
        }
        StringBuilder builder = new StringBuilder();
        tsPaths.forEach(path -> {
            builder.append("export * from \"");
            builder.append((String)path);
            builder.append("\";");
            builder.append("\n");
        });
        try (FileWriter writer = new FileWriter(outputFile);){
            writer.write(builder.toString());
        }
        System.out.println("Successfully created core.ts file with " + tsPaths.size() + " ts files.");
    }

    private static Set<String> findTsPaths(File srcDir) {
        TreeSet<String> paths = new TreeSet<String>();
        GenerateCoreTs.findTsPaths(srcDir, paths);
        return paths;
    }

    private static void findTsPaths(File srcDir, Set<String> paths) {
        for (File file : srcDir.listFiles()) {
            if (file.isFile() && file.getName().endsWith(".ts")) {
                String fullPath = file.getAbsolutePath();
                if (!fullPath.startsWith(rootDir)) continue;
                String relativePath = "." + fullPath.substring(rootDir.length(), fullPath.length() - 3).replace('\\', '/');
                paths.add(relativePath);
                continue;
            }
            if (!file.isDirectory()) continue;
            GenerateCoreTs.findTsPaths(file, paths);
        }
    }
}

