/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai.metadata;

import com.azure.ai.openai.models.ChatCompletions;
import java.util.HashMap;
import org.springframework.ai.azure.openai.metadata.AzureOpenAiUsage;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.PromptMetadata;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.util.Assert;

public class AzureOpenAiChatResponseMetadata
extends HashMap<String, Object>
implements ChatResponseMetadata {
    protected static final String AI_METADATA_STRING = "{ @type: %1$s, id: %2$s, usage: %3$s, rateLimit: %4$s }";
    private final String id;
    private final Usage usage;
    private final PromptMetadata promptMetadata;

    public static AzureOpenAiChatResponseMetadata from(ChatCompletions chatCompletions, PromptMetadata promptFilterMetadata) {
        Assert.notNull((Object)chatCompletions, (String)"Azure OpenAI ChatCompletions must not be null");
        String id = chatCompletions.getId();
        AzureOpenAiUsage usage = AzureOpenAiUsage.from(chatCompletions);
        AzureOpenAiChatResponseMetadata chatResponseMetadata = new AzureOpenAiChatResponseMetadata(id, usage, promptFilterMetadata);
        return chatResponseMetadata;
    }

    protected AzureOpenAiChatResponseMetadata(String id, AzureOpenAiUsage usage, PromptMetadata promptMetadata) {
        this.id = id;
        this.usage = usage;
        this.promptMetadata = promptMetadata;
    }

    public String getId() {
        return this.id;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public PromptMetadata getPromptMetadata() {
        return this.promptMetadata;
    }

    @Override
    public String toString() {
        return AI_METADATA_STRING.formatted(this.getClass().getTypeName(), this.getId(), this.getUsage(), this.getRateLimit());
    }
}

