/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.models.EmbeddingItem;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.ai.openai.models.EmbeddingsUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingOptions;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.Assert;

public class AzureOpenAiEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(AzureOpenAiEmbeddingModel.class);
    private final OpenAIClient azureOpenAiClient;
    private final AzureOpenAiEmbeddingOptions defaultOptions;
    private final MetadataMode metadataMode;

    public AzureOpenAiEmbeddingModel(OpenAIClient azureOpenAiClient) {
        this(azureOpenAiClient, MetadataMode.EMBED);
    }

    public AzureOpenAiEmbeddingModel(OpenAIClient azureOpenAiClient, MetadataMode metadataMode) {
        this(azureOpenAiClient, metadataMode, AzureOpenAiEmbeddingOptions.builder().withDeploymentName("text-embedding-ada-002").build());
    }

    public AzureOpenAiEmbeddingModel(OpenAIClient azureOpenAiClient, MetadataMode metadataMode, AzureOpenAiEmbeddingOptions options) {
        Assert.notNull((Object)azureOpenAiClient, (String)"com.azure.ai.openai.OpenAIClient must not be null");
        Assert.notNull((Object)metadataMode, (String)"Metadata mode must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        this.azureOpenAiClient = azureOpenAiClient;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
    }

    public List<Double> embed(Document document) {
        logger.debug("Retrieving embeddings");
        EmbeddingResponse response = this.call(new EmbeddingRequest(List.of(document.getFormattedContent(this.metadataMode)), null));
        logger.debug("Embeddings retrieved");
        return response.getResults().stream().map(embedding -> embedding.getOutput()).flatMap(Collection::stream).toList();
    }

    public EmbeddingResponse call(EmbeddingRequest embeddingRequest) {
        logger.debug("Retrieving embeddings");
        EmbeddingsOptions azureOptions = this.toEmbeddingOptions(embeddingRequest);
        Embeddings embeddings = this.azureOpenAiClient.getEmbeddings(azureOptions.getModel(), azureOptions);
        logger.debug("Embeddings retrieved");
        return this.generateEmbeddingResponse(embeddings);
    }

    EmbeddingsOptions toEmbeddingOptions(EmbeddingRequest embeddingRequest) {
        EmbeddingsOptions azureOptions = new EmbeddingsOptions(embeddingRequest.getInstructions());
        if (this.defaultOptions != null) {
            azureOptions.setModel(this.defaultOptions.getDeploymentName());
            azureOptions.setUser(this.defaultOptions.getUser());
        }
        if (embeddingRequest.getOptions() != null && !EmbeddingOptions.EMPTY.equals((Object)embeddingRequest.getOptions())) {
            azureOptions = (EmbeddingsOptions)ModelOptionsUtils.merge((Object)embeddingRequest.getOptions(), (Object)azureOptions, EmbeddingsOptions.class);
        }
        return azureOptions;
    }

    private EmbeddingResponse generateEmbeddingResponse(Embeddings embeddings) {
        List<Embedding> data = this.generateEmbeddingList(embeddings.getData());
        EmbeddingResponseMetadata metadata = this.generateMetadata(embeddings.getUsage());
        return new EmbeddingResponse(data, metadata);
    }

    private List<Embedding> generateEmbeddingList(List<EmbeddingItem> nativeData) {
        ArrayList<Embedding> data = new ArrayList<Embedding>();
        for (EmbeddingItem nativeDatum : nativeData) {
            List nativeDatumEmbedding = nativeDatum.getEmbedding();
            int nativeIndex = nativeDatum.getPromptIndex();
            Embedding embedding = new Embedding(nativeDatumEmbedding.stream().map(f -> f.doubleValue()).toList(), Integer.valueOf(nativeIndex));
            data.add(embedding);
        }
        return data;
    }

    private EmbeddingResponseMetadata generateMetadata(EmbeddingsUsage embeddingsUsage) {
        EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();
        metadata.put((Object)"prompt-tokens", (Object)embeddingsUsage.getPromptTokens());
        metadata.put((Object)"total-tokens", (Object)embeddingsUsage.getTotalTokens());
        return metadata;
    }

    public AzureOpenAiEmbeddingOptions getDefaultOptions() {
        return this.defaultOptions;
    }
}

