/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.azure.openai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.azure.openai.AzureOpenAiResponseFormat;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AzureOpenAiChatOptions
implements FunctionCallingOptions,
ChatOptions {
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="temperature")
    private Float temperature;
    @JsonProperty(value="top_p")
    private Float topP;
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="deployment_name")
    private String deploymentName;
    @JsonProperty(value="response_format")
    private AzureOpenAiResponseFormat responseFormat;
    @NestedConfigurationProperty
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @NestedConfigurationProperty
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    @JsonIgnore
    public Integer getTopK() {
        throw new UnsupportedOperationException("Unimplemented method 'getTopK'");
    }

    @JsonIgnore
    public void setTopK(Integer topK) {
        throw new UnsupportedOperationException("Unimplemented method 'setTopK'");
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
    }

    public AzureOpenAiResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(AzureOpenAiResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public static AzureOpenAiChatOptions fromOptions(AzureOpenAiChatOptions fromOptions) {
        return AzureOpenAiChatOptions.builder().withDeploymentName(fromOptions.getDeploymentName()).withFrequencyPenalty(fromOptions.getFrequencyPenalty() != null ? Float.valueOf(fromOptions.getFrequencyPenalty().floatValue()) : null).withLogitBias(fromOptions.getLogitBias()).withMaxTokens(fromOptions.getMaxTokens()).withN(fromOptions.getN()).withPresencePenalty(fromOptions.getPresencePenalty() != null ? Float.valueOf(fromOptions.getPresencePenalty().floatValue()) : null).withStop(fromOptions.getStop()).withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withUser(fromOptions.getUser()).withFunctionCallbacks(fromOptions.getFunctionCallbacks()).withFunctions(fromOptions.getFunctions()).build();
    }

    public static class Builder {
        protected AzureOpenAiChatOptions options;

        public Builder() {
            this.options = new AzureOpenAiChatOptions();
        }

        public Builder(AzureOpenAiChatOptions options) {
            this.options = options;
        }

        public Builder withDeploymentName(String deploymentName) {
            this.options.deploymentName = deploymentName;
            return this;
        }

        public Builder withFrequencyPenalty(Float frequencyPenalty) {
            if (frequencyPenalty != null) {
                this.options.frequencyPenalty = frequencyPenalty.doubleValue();
            }
            return this;
        }

        public Builder withLogitBias(Map<String, Integer> logitBias) {
            this.options.logitBias = logitBias;
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder withN(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder withPresencePenalty(Float presencePenalty) {
            if (presencePenalty != null) {
                this.options.presencePenalty = presencePenalty.doubleValue();
            }
            return this;
        }

        public Builder withStop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder withTemperature(Float temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder withTopP(Float topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder withUser(String user) {
            this.options.user = user;
            return this;
        }

        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder withFunctions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder withFunction(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public Builder withResponseFormat(AzureOpenAiResponseFormat responseFormat) {
            Assert.notNull((Object)((Object)responseFormat), (String)"responseFormat must not be null");
            this.options.responseFormat = responseFormat;
            return this;
        }

        public AzureOpenAiChatOptions build() {
            return this.options;
        }
    }
}

