/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac.kerberos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.login.LoginException;
import jcifs.pac.ASN1Util;
import jcifs.pac.PACDecodingException;
import jcifs.pac.kerberos.KerberosCredentials;
import jcifs.pac.kerberos.KerberosEncData;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DEROctetString;

public class KerberosTicket {
    private String serverPrincipalName;
    private String serverRealm;
    private KerberosEncData encData;

    public KerberosTicket(byte[] token, byte apOptions, KerberosKey[] keys) throws PACDecodingException {
        ASN1Sequence sequence;
        if (token.length <= 0) {
            throw new PACDecodingException("Empty kerberos ticket");
        }
        try (ASN1InputStream stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(token));){
            sequence = ASN1Util.as(ASN1Sequence.class, stream);
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos ticket", e);
        }
        Enumeration fields = sequence.getObjects();
        block21: while (fields.hasMoreElements()) {
            ASN1TaggedObject tagged = ASN1Util.as(ASN1TaggedObject.class, fields);
            switch (tagged.getTagNo()) {
                case 0: {
                    ASN1Integer tktvno = ASN1Util.as(ASN1Integer.class, tagged);
                    if (tktvno.getValue().equals(new BigInteger("5"))) continue block21;
                    throw new PACDecodingException("Invalid kerberos version " + tktvno);
                }
                case 1: {
                    DERGeneralString derRealm = ASN1Util.as(DERGeneralString.class, tagged);
                    this.serverRealm = derRealm.getString();
                    continue block21;
                }
                case 2: {
                    ASN1Sequence principalSequence = ASN1Util.as(ASN1Sequence.class, tagged);
                    ASN1Sequence nameSequence = ASN1Util.as(ASN1Sequence.class, ASN1Util.as(ASN1TaggedObject.class, principalSequence, 1));
                    StringBuilder nameBuilder = new StringBuilder();
                    Enumeration parts = nameSequence.getObjects();
                    while (parts.hasMoreElements()) {
                        Object part = parts.nextElement();
                        DERGeneralString stringPart = ASN1Util.as(DERGeneralString.class, part);
                        nameBuilder.append(stringPart.getString());
                        if (!parts.hasMoreElements()) continue;
                        nameBuilder.append('/');
                    }
                    this.serverPrincipalName = nameBuilder.toString();
                    continue block21;
                }
                case 3: {
                    ASN1Sequence encSequence = ASN1Util.as(ASN1Sequence.class, tagged);
                    ASN1Integer encType = ASN1Util.as(ASN1Integer.class, ASN1Util.as(ASN1TaggedObject.class, encSequence, 0));
                    DEROctetString encOctets = ASN1Util.as(DEROctetString.class, ASN1Util.as(ASN1TaggedObject.class, encSequence, 2));
                    byte[] crypt = encOctets.getOctets();
                    if (keys == null) {
                        try {
                            keys = new KerberosCredentials().getKeys();
                        }
                        catch (LoginException e) {
                            throw new PACDecodingException("Login failure", e);
                        }
                    }
                    HashMap<Integer, KerberosKey> keysByAlgo = new HashMap<Integer, KerberosKey>();
                    for (KerberosKey key : keys) {
                        keysByAlgo.put(key.getKeyType(), key);
                    }
                    KerberosKey serverKey = (KerberosKey)keysByAlgo.get(encType.getValue().intValue());
                    if (keysByAlgo.isEmpty() || serverKey == null) {
                        throw new PACDecodingException("Kerberos key not found for eType " + encType.getValue());
                    }
                    try {
                        byte[] decrypted = KerberosEncData.decrypt(crypt, serverKey, serverKey.getKeyType());
                        this.encData = new KerberosEncData(decrypted, keysByAlgo);
                        continue block21;
                    }
                    catch (GeneralSecurityException e) {
                        throw new PACDecodingException("Decryption failed " + serverKey.getKeyType(), e);
                    }
                }
            }
            throw new PACDecodingException("Unrecognized field " + tagged.getTagNo());
        }
    }

    public String getUserPrincipalName() {
        return this.encData.getUserPrincipalName();
    }

    public String getUserRealm() {
        return this.encData.getUserRealm();
    }

    public String getServerPrincipalName() {
        return this.serverPrincipalName;
    }

    public String getServerRealm() {
        return this.serverRealm;
    }

    public KerberosEncData getEncData() {
        return this.encData;
    }
}

