/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.nego;

import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb2.nego.NegotiateContextRequest;
import jcifs.internal.smb2.nego.NegotiateContextResponse;
import jcifs.internal.util.SMBUtil;

public class PreauthIntegrityNegotiateContext
implements NegotiateContextRequest,
NegotiateContextResponse {
    public static final int NEGO_CTX_PREAUTH_TYPE = 1;
    public static final int HASH_ALGO_SHA512 = 1;
    private int[] hashAlgos;
    private byte[] salt;

    public PreauthIntegrityNegotiateContext(Configuration config, int[] hashAlgos, byte[] salt) {
        this.hashAlgos = hashAlgos;
        this.salt = salt;
    }

    public PreauthIntegrityNegotiateContext() {
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int[] getHashAlgos() {
        return this.hashAlgos;
    }

    @Override
    public int getContextType() {
        return 1;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.hashAlgos != null ? (long)this.hashAlgos.length : 0L, dst, dstIndex);
        SMBUtil.writeInt2(this.salt != null ? (long)this.salt.length : 0L, dst, dstIndex + 2);
        dstIndex += 4;
        if (this.hashAlgos != null) {
            for (int hashAlgo : this.hashAlgos) {
                SMBUtil.writeInt2(hashAlgo, dst, dstIndex);
                dstIndex += 2;
            }
        }
        if (this.salt != null) {
            System.arraycopy(this.salt, 0, dst, dstIndex, this.salt.length);
            dstIndex += this.salt.length;
        }
        return dstIndex - start;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int nalgos = SMBUtil.readInt2(buffer, bufferIndex);
        int nsalt = SMBUtil.readInt2(buffer, bufferIndex + 2);
        bufferIndex += 4;
        this.hashAlgos = new int[nalgos];
        for (int i = 0; i < nalgos; ++i) {
            this.hashAlgos[i] = SMBUtil.readInt2(buffer, bufferIndex);
            bufferIndex += 2;
        }
        this.salt = new byte[nsalt];
        System.arraycopy(buffer, bufferIndex, this.salt, 0, nsalt);
        return (bufferIndex += nsalt) - start;
    }

    @Override
    public int size() {
        return 4 + (this.hashAlgos != null ? 2 * this.hashAlgos.length : 0) + (this.salt != null ? this.salt.length : 0);
    }
}

