/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.BitSet;

public final class BitUtil
implements Serializable {
    private BitUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(BitSet bits) {
        BitSet bitSet = bits;
        synchronized (bitSet) {
            byte[] bytes = new byte[bits.length() / 8 + 1];
            int i = 0;
            while (i < bits.length()) {
                if (bits.get(i)) {
                    int n = bytes.length - i / 8 - 1;
                    bytes[n] = (byte)(bytes[n] | 1 << i % 8);
                }
                ++i;
            }
            return bytes;
        }
    }

    public static int toInt(BitSet bits, int length) {
        byte[] bytes = BitUtil.toByteArray(bits);
        int value = new BigInteger(bytes).intValue();
        if ((double)value > Math.pow(2.0, length - 1) && length != -1) {
            value -= (int)Math.pow(2.0, length);
        }
        return value;
    }

    public static BitSet fromString(String value) {
        if (!value.startsWith("{")) {
            BitSet set = new BitSet(value.length());
            int i = 0;
            while (i < value.length()) {
                if (value.charAt(i) == '1') {
                    set.set(i, true);
                } else if (value.charAt(i) == '0') {
                    set.set(i, false);
                } else {
                    throw new IllegalArgumentException("value should only contain ones and zeros. Try 110011");
                }
                ++i;
            }
            return set;
        }
        BitSet set = new BitSet();
        if ((value = value.substring(1, value.length() - 1)).equals("")) {
            return set;
        }
        String[] bits = value.split(",");
        int i = 0;
        while (i < bits.length) {
            bits[i] = bits[i].trim();
            set.set(Integer.valueOf(bits[i]));
            ++i;
        }
        return set;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        int i = 0;
        while (i < bytes.length * 8) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) > 0) {
                bits.set(i);
            }
            ++i;
        }
        return bits;
    }

    public static BitSet fromInt(int value, int length) {
        return BitUtil.fromInteger(new Integer(value), length);
    }

    public static BitSet fromInteger(Integer value, int length) {
        if (value < 0 && length != -1) {
            value = new Integer((int)Math.pow(2.0, length) + value);
        }
        return BitUtil.fromByteArray(new BigInteger(value.toString()).toByteArray());
    }

    public static BitSet fromBoolean(boolean value) {
        BitSet result = new BitSet(1);
        result.set(0, value);
        return result;
    }
}

