/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

public class JMultiToolbarFrame
extends JFrame
implements SwingConstants {
    protected Container currentContentPane;
    protected Vector containerStack = new Vector();
    protected Vector toolbarStack = new Vector();
    protected Container topContainer;
    protected boolean isEmpty = true;

    public JMultiToolbarFrame() {
        this.currentContentPane = new JPanel(new BorderLayout());
        this.topContainer = super.getContentPane();
        this.topContainer.add((Component)this.currentContentPane, "Center");
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setEmpty(boolean empty) {
        this.isEmpty = empty;
    }

    public Container getContentPane() {
        return this.currentContentPane;
    }

    public void addJToolBar(JToolBar bar, int align) {
        if (!this.toolbarStack.contains(bar)) {
            int orientation;
            String border;
            switch (align) {
                case 1: {
                    border = "North";
                    orientation = 0;
                    break;
                }
                case 3: {
                    border = "South";
                    orientation = 0;
                    break;
                }
                case 2: {
                    border = "West";
                    orientation = 1;
                    break;
                }
                case 4: {
                    border = "East";
                    orientation = 1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Alignment argument passed to JMultiToolbarFrame.addJToolBar is not one of SwingConstants.TOP/BOTTOM/LEFT/RIGHT.");
                }
            }
            this.topContainer.remove(this.currentContentPane);
            JPanel newContainer = new JPanel(new BorderLayout());
            newContainer.add((Component)bar, border);
            newContainer.add((Component)this.currentContentPane, "Center");
            this.topContainer.add(newContainer);
            this.topContainer = newContainer;
            this.containerStack.addElement(newContainer);
            bar.setOrientation(orientation);
            this.toolbarStack.addElement(bar);
        }
    }

    public void removeJToolBar(JToolBar bar) {
        if (this.toolbarStack.contains(bar)) {
            int position = this.toolbarStack.indexOf(bar);
            Container below = position != 0 ? (Container)this.containerStack.elementAt(position - 1) : super.getContentPane();
            Container above = position != this.containerStack.size() - 1 ? (Container)this.containerStack.elementAt(position + 1) : this.currentContentPane;
            Container current = (Container)this.containerStack.elementAt(position);
            below.remove(current);
            current.remove(above);
            below.add((Component)above, "Center");
        }
    }
}

