/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.language.reflection;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import nl.tudelft.simulation.language.reflection.FieldSignature;

public class MethodSignature
implements Serializable {
    private String value = null;

    public MethodSignature(String value) {
        this.value = value;
    }

    public MethodSignature(Method method) {
        Class[] parameterTypes = new Class[]{};
        if (method.getParameterTypes() != null) {
            parameterTypes = method.getParameterTypes();
        }
        this.value = "(";
        int i = 0;
        while (i < parameterTypes.length) {
            this.value = String.valueOf(this.value) + FieldSignature.toDescriptor(parameterTypes[i]);
            ++i;
        }
        this.value = String.valueOf(this.value) + ")" + FieldSignature.toDescriptor(method.getReturnType());
    }

    public MethodSignature(Constructor constructor) {
        Class[] parameterTypes = new Class[]{};
        if (constructor.getParameterTypes() != null) {
            parameterTypes = constructor.getParameterTypes();
        }
        this.value = "(";
        int i = 0;
        while (i < parameterTypes.length) {
            this.value = String.valueOf(this.value) + FieldSignature.toDescriptor(parameterTypes[i]);
            ++i;
        }
        this.value = String.valueOf(this.value) + ")" + FieldSignature.toDescriptor(constructor.getDeclaringClass());
    }

    public String getParameterDescriptor() {
        return MethodSignature.getParameterDescriptor(this.value);
    }

    public Class[] getParameterTypes() throws ClassNotFoundException {
        return MethodSignature.getParameterTypes(this.value);
    }

    public String getReturnDescriptor() {
        return MethodSignature.getReturnDescriptor(this.value);
    }

    public Class getReturnType() throws ClassNotFoundException {
        return MethodSignature.getReturnType(this.value);
    }

    public String toString() {
        return this.value;
    }

    public static String getParameterDescriptor(String methodDescriptor) {
        return methodDescriptor.substring(1, methodDescriptor.indexOf(41));
    }

    public static Class[] getParameterTypes(String methodDescriptor) throws ClassNotFoundException {
        String parameterDescriptor = MethodSignature.getParameterDescriptor(methodDescriptor);
        ArrayList<Class> result = new ArrayList<Class>();
        int length = 0;
        while (length < parameterDescriptor.length()) {
            String array = "";
            while (parameterDescriptor.charAt(length) == '[') {
                array = String.valueOf(array) + "[";
                ++length;
            }
            if (parameterDescriptor.charAt(length) == 'L') {
                String argument = parameterDescriptor.substring(length);
                argument = String.valueOf(array) + argument.substring(0, argument.indexOf(59) + 1);
                result.add(FieldSignature.toClass(argument));
                length = length + argument.length() - array.length();
                continue;
            }
            result.add(FieldSignature.toClass(String.valueOf(array) + parameterDescriptor.charAt(length)));
            ++length;
        }
        return result.toArray(new Class[result.size()]);
    }

    public static String getReturnDescriptor(String methodDescriptor) {
        return methodDescriptor.substring(methodDescriptor.indexOf(41) + 1);
    }

    public static Class getReturnType(String methodDescriptor) throws ClassNotFoundException {
        return FieldSignature.toClass(MethodSignature.getReturnDescriptor(methodDescriptor));
    }
}

