/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;

public class RungeKuttaCashCarp
extends NumericalIntegrator {
    protected static double[] a = new double[]{0.0, 0.2, 0.3, 0.6, 1.0, 0.875};
    protected static double[][] b = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.2, 0.075, 0.3, -0.2037037037037037, 0.029495804398148147}, {0.0, 0.225, -0.9, 2.5, 0.8254716981132075}, {0.0, 0.0, 1.2, -2.5925925925925926, 0.041594328703703706}, {0.0, 0.0, 0.0, 1.2962962962962963, 0.40034541377314814}, {0.0, 0.0, 0.0, 0.0, 0.061767578125}};
    protected static double[] c = new double[]{0.09788359788359788, 0.0, 0.4025764895330113, 0.21043771043771045, 0.0, 0.2891022021456804};
    protected static double[] c4 = new double[]{0.10217737268518519, 0.0, 0.38390790343915343, 0.24459273726851852, 0.019321986607142856, 0.25};
    protected static int nk = 6;

    public RungeKuttaCashCarp(double timeStep, DifferentialEquationInterface equation) {
        super(timeStep, equation);
    }

    public double[] next(double x, double[] y) {
        double[][] k = new double[nk][];
        for (int i = 0; i < nk; ++i) {
            double[] ysum = (double[])y.clone();
            for (int j = 0; j < i; ++j) {
                if (b[i][j] == 0.0) continue;
                ysum = this.add(ysum, this.multiply(b[i][j], k[j]));
            }
            k[i] = this.multiply(this.timeStep, this.equation.dy(x + a[i] * this.timeStep, ysum));
        }
        double[] sum = (double[])y.clone();
        this.error = new double[y.length];
        for (int i = 0; i < nk; ++i) {
            sum = this.add(sum, this.multiply(c[i], k[i]));
            this.error = this.add(this.error, this.multiply(c[i] - c4[i], k[i]));
        }
        return sum;
    }
}

