/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.ode.integrators;

import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;

public abstract class CachingNumericalIntegrator
extends NumericalIntegrator {
    private int cachePlaces = 0;
    private double[][] cacheY;
    private double[][] cacheDY;
    private int lastCachePlace = -1;
    protected NumericalIntegrator startingIntegrator = null;
    protected int startingSubSteps = 10;

    public CachingNumericalIntegrator(double timeStep, DifferentialEquationInterface equation, int cachePlaces, short integrationMethod, int startingSubSteps) {
        super(timeStep, equation);
        this.cachePlaces = cachePlaces;
        this.cacheY = new double[cachePlaces][];
        this.cacheDY = new double[cachePlaces][];
        this.startingIntegrator = NumericalIntegrator.resolve(integrationMethod, timeStep / (1.0 * (double)startingSubSteps), equation);
        this.startingSubSteps = startingSubSteps;
    }

    public void setTimeStep(double timeStep) {
        super.setTimeStep(timeStep);
        this.lastCachePlace = -1;
    }

    public double[] next(double x, double[] y) {
        double[] ynext = null;
        if (this.lastCachePlace < this.cachePlaces) {
            ynext = (double[])y.clone();
            double xstep = x;
            for (int i = 0; i < this.startingSubSteps; ++i) {
                ynext = this.startingIntegrator.next(xstep, ynext);
                xstep += this.timeStep / (1.0 * (double)this.startingSubSteps);
            }
        } else {
            ynext = this.next(x);
        }
        ++this.lastCachePlace;
        this.cacheY[this.lastCachePlace % this.cachePlaces] = ynext;
        this.cacheDY[this.lastCachePlace % this.cachePlaces] = this.equation.dy(x + this.timeStep, ynext);
        return ynext;
    }

    public double[] getY(int numberDown) {
        if (this.lastCachePlace < this.cachePlaces) {
            throw new RuntimeException("Tried to retrieve y-value that was not yet primed");
        }
        if (numberDown >= this.cachePlaces) {
            throw new RuntimeException("Tried to retrieve y-value beyond cache limits");
        }
        return (double[])this.cacheY[(this.lastCachePlace - numberDown) % this.cachePlaces].clone();
    }

    public double[] getDY(int numberDown) {
        if (this.lastCachePlace < this.cachePlaces) {
            throw new RuntimeException("Tried to retrieve dy-value that was not yet primed");
        }
        if (numberDown >= this.cachePlaces) {
            throw new RuntimeException("Tried to retrieve dy-value beyond cache limits");
        }
        return (double[])this.cacheDY[(this.lastCachePlace - numberDown) % this.cachePlaces].clone();
    }

    public abstract double[] next(double var1);
}

