/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.ode;

import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.jstats.ode.DifferentialEquationInterface;
import nl.tudelft.simulation.jstats.ode.integrators.NumericalIntegrator;

public abstract class DifferentialEquation
extends EventProducer
implements DifferentialEquationInterface {
    private NumericalIntegrator integrator = null;
    protected double[] y0 = null;
    protected double timeStep = Double.NaN;
    protected double x0 = Double.NaN;

    public DifferentialEquation(double timeStep) {
        this(timeStep, 3);
    }

    public DifferentialEquation(double timeStep, NumericalIntegrator integrator) {
        this.timeStep = timeStep;
        this.integrator = integrator;
    }

    public DifferentialEquation(double timeStep, short integrationMethod) {
        this.timeStep = timeStep;
        this.integrator = NumericalIntegrator.resolve(integrationMethod, timeStep, this);
    }

    public void initialize(double x, double[] y) {
        this.x0 = x;
        this.y0 = y;
    }

    public double[] y(double x) {
        if (Double.isNaN(this.x0)) {
            throw new RuntimeException("differential equation not initialized");
        }
        if (x < this.x0) {
            throw new RuntimeException("cannot compute values x<x0");
        }
        return this.integrateY(x, this.x0, this.y0);
    }

    protected double[] integrateY(double x, double initialX, double[] initialY) {
        while (x > initialX + this.timeStep) {
            initialY = this.integrator.next(initialX, initialY);
            initialX += this.timeStep;
        }
        double[] nextValue = this.integrator.next(initialX, initialY);
        double ratio = (x - initialX) / this.timeStep;
        for (int i = 0; i < initialY.length; ++i) {
            initialY[i] = initialY[i] + ratio * (nextValue[i] - initialY[i]);
        }
        return initialY;
    }

    public NumericalIntegrator getIntegrator() {
        return this.integrator;
    }

    public void setIntegrator(NumericalIntegrator integrator) {
        this.integrator = integrator;
    }

    public abstract /* synthetic */ double[] dy(double var1, double[] var3);
}

