/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.jstats.distributions;

import nl.tudelft.simulation.jstats.distributions.DistDiscrete;
import nl.tudelft.simulation.jstats.math.ProbMath;
import nl.tudelft.simulation.jstats.streams.StreamInterface;

public class DistNegBinomial
extends DistDiscrete {
    private long n;
    private double p;
    private double lnp;

    public DistNegBinomial(StreamInterface stream, long n, double p) {
        super(stream);
        if (n <= 0L || !(p > 0.0) || !(p < 1.0)) {
            throw new IllegalArgumentException("Error NegBinomial - n<=0 or p<=0.0 or p>=1.0");
        }
        this.n = n;
        this.p = p;
        this.lnp = Math.log(1.0 - this.p);
    }

    public long draw() {
        long x = 0L;
        for (long i = 0L; i < this.n; ++i) {
            double u = this.stream.nextDouble();
            x += (long)Math.floor(Math.log(u) / this.lnp);
        }
        return x;
    }

    public double probability(int observation) {
        if (observation >= 0) {
            return ProbMath.permutations((int)this.n + observation - 1, observation) * Math.pow(this.p, this.n) * Math.pow(1.0 - this.p, observation);
        }
        return 0.0;
    }

    public String toString() {
        return "NegBinomial(" + this.n + "," + this.p + ")";
    }
}

